/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef MODULE_SERVLET_CGI_SERVLET_H
#define MODULE_SERVLET_CGI_SERVLET_H

#include <map>
#include <string>
#include <boost/thread/thread.hpp>

#include <sl/class_loader/register.hpp>
#include <servlet/http/HttpServlet.h>

namespace modules {
namespace servlets {

/**
 * class CGIServlet.
 *
 * CGI ¹Ԥ뤿 Servlet Ǥ.
 * Ūˤñ fork ˤҥץԤ
 * exec ˤäƥץ¹ԤñʻȤߤǤ.
 *
 * ͤȤ cgiPathPrefix  clientInputTimeout ǽǤ.
 * cgiPathPrefix WebץꥱΥ롼ȥǥ쥯ȥ꤫
 * CGIץȤ֤Ƥѥꤷޤ.
 * clientInputTimeout ϥꥯȤϾԤĻ֤ꤷޤ.
 * ñ̤ϥߥäǤ.
 *
 * ĥ
 * Tomcat ɤ¸ƤΤʤΤǤ
 *  CGIServlet  web.xml  init-param Ǥ˴Ķѿ
 * ɵ뤳Ȥޤ.
 * init-param Ǥ param-name Ƭ 'ENV:' դ
 * Ƭ 'ENV:' ͤĶѿ̾Ȥơ³ param-value 
 * δĶѿͤȤʤޤ.
 *
 * Х.
 * 󥹥ȡǤ conf/web.xml  CGIServlet ν꤬
 * 񤫤ƤޤWebץꥱѹ뤳Ȥޤ
 * 㤨 ROOT/WEB-INF/web.xml  CGIServlet ɵƵưƤ
 * ROOT/۲˥ conf/web.xml ͤưƤޤޤ.
 */
class CGIServlet : public servlet::http::HttpServlet {
public :
    CGIServlet();
    ~CGIServlet();

    void init() throw(servlet::ServletException);

    void destroy() throw();

    void service(servlet::http::HttpServletRequest& req,
                 servlet::http::HttpServletResponse& res)
        throw(servlet::ServletException);

private :
    void env(const std::string& target,
             servlet::http::HttpServletRequest& req,
             servlet::http::HttpServletResponse& res,
             const std::string& scritp_name,
             const std::string& path_info);

    void exec(const std::string& dir,
              servlet::http::HttpServletRequest& req,
              servlet::http::HttpServletResponse& res,
              const std::string& scritp_name,
              const std::string& path_info);

    void inputForward(servlet::http::HttpServletRequest* req, int outfd);
    void errorLog(int e, const std::string& func);

    std::string nameForCGI(const std::string& str);
    void parseStatusHeader(const std::string& s, std::string& c, std::string& r);

private :
    std::map<std::string, std::string> _env;
    std::string _cgipath;
    std::string _webappdir;
    long        _timeout;

    boost::thread* _input_forward_thread;
};

} // namespace servlets
} // namespace modules

SL_REGIST_LOADABLE_CLASS(modules::servlets::CGIServlet)

#endif // MODULE_SERVLET_CGI_SERVLET_H
