/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef SHIBAINU_MEMORY_REALM_H
#define SHIBAINU_MEMORY_REALM_H

#include <string>
#include <sl/class_loader/register.hpp>
#include <sl/java/security/Principal.h>

#include <si/interface/Realm.h>
#include "modules/core/DefaultBase.h"

namespace modules {
namespace realm {

class MemoryRealm
  : virtual modules::core::DefaultBase, virtual public si::interface::Realm
{
public :
    MemoryRealm();

    virtual ~MemoryRealm();

    void init();

    void destroy();

    virtual sl::java::security::Principal&
    authorization(const si::interface::Config& auth);

private :
    virtual sl::java::security::Principal&
    basic_authorization(const si::interface::Config& auth);

    virtual sl::java::security::Principal&
    digest_authorization(const si::interface::Config& auth);

    virtual sl::java::security::Principal&
    cert_authorization(const si::interface::Config& auth);

    std::string _username;
    std::string _password;

    sl::java::security::Principal* _principal;
    sl::java::security::Principal* _null_principal;
};

} // namespace realm
} // namespace modules

SL_REGIST_LOADABLE_CLASS(modules::realm::MemoryRealm)

#endif // SHIBAINU_MEMORY_REALM_H
