/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: StdOutLogger.h,v 1.10 2008/05/06 16:26:11 cvsuser Exp $
 */

#ifndef SHIBAINU_STDOUT_LOGGER_H
#define SHIBAINU_STDOUT_LOGGER_H

#include <string>
#include <boost/thread/mutex.hpp>
#include <sl/class_loader/register.hpp>

#include <si/interface/Logger.h>
#include <si/interface/Config.h>
using namespace si::interface;

namespace si { namespace modules {

	class StdOutLogger : public si::interface::Logger {
	public :
		StdOutLogger();

		virtual void config(const interface::Config& c);

		virtual interface::Config config();

		virtual void open();

		virtual void close();

		virtual void log(const std::string &msg);

		virtual void log(const std::string &msg, int level);

		virtual void log(const std::string &msg, const std::exception &);

	private :
		int					_level;
		interface::Config	_config;
		boost::mutex		_mutex;
		bool				_parallel;
	};

	SL_REGIST_LOADABLE_CLASS(StdOutLogger)

} } // namespace si::modules

#endif // SHIBAINU_STDOUT_LOGGER_H
