/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: StdOutLogger.cpp,v 1.9 2008/05/06 16:26:11 cvsuser Exp $
 */

#include <iostream>
#include <boost/thread/mutex.hpp>
using namespace std;
using namespace boost;

#include "StdOutLogger.h"
using namespace si::interface;
using namespace si::modules;

std::string lv2s(int level)
{
	switch (level) {
	case Logger::FATAL_LOG :
		return "fatal";
	case Logger::ERROR_LOG :
		return "error";
	case Logger::WARN_LOG :
		return "warn";
	case Logger::DEBUG_LOG :
		return "debug";
	default :
		return "notice";
	}
}


//
// Constructor/Destructor
//

StdOutLogger::StdOutLogger()
	: _parallel(true)
{ }


//
// Member functions.
//

void StdOutLogger::config(const interface::Config& c)
{
	_config = c;
	_parallel = (c.attr("parallel") != "false");
}

Config StdOutLogger::config()
{
	return _config;
}

void StdOutLogger::open()
{ }

void StdOutLogger::close()
{ }

void StdOutLogger::log(const string& msg)
{
	if (_parallel)
		mutex::scoped_lock lock(_mutex);
	cerr << msg << endl;
}

void StdOutLogger::log(const string& msg, int level)
{
	if (_parallel)
		mutex::scoped_lock lock(_mutex);
	cerr << "[" << lv2s(level) << "] " << msg << endl;
}

void StdOutLogger::log(const string& msg, const std::exception& e)
{
	if (_parallel)
		mutex::scoped_lock lock(_mutex);
	cerr << "[exception] " << msg << " - " << e.what() << endl;
}
