/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef SHIBAINU_DEFAULT_LOGGER_H
#define SHIBAINU_DEFAULT_LOGGER_H

#include <deque>
#include <fstream>
#include <string>
#include <exception>
#include <boost/thread/thread.hpp>
#include <boost/thread/mutex.hpp>
#include <boost/thread/condition.hpp>
#include <sl/class_loader/register.hpp>
#include <si/interface/Logger.h>
#include <si/interface/Config.h>

namespace modules {
namespace logger {

struct msg_part {
    msg_part(time_t t, int l, const std::string& m)
        : _time(t), _level(l), _msg(m) { }
    msg_part(const msg_part& l)
    {
        _time  = l._time;
        _level = l._level;
        _msg   = l._msg;
    }
    time_t _time;
    int _level;
    std::string _msg;
};

class DefaultLogger : public si::interface::Logger {
public :
    DefaultLogger();

    ~DefaultLogger();

    virtual void config(const si::interface::Config& c);

    virtual si::interface::Config config();

    virtual void open();

    virtual void close();

    virtual void log(const std::string& msg);

    virtual void log(const std::string& msg, int level);

    virtual void log(const std::string& msg, const std::exception& e);

private :

    void output_thr();
    void write(const msg_part& m);

    bool _is_open;
    int _level;
    std::ofstream _ofs;

    si::interface::Config _config;
    std::string _home;
    std::string _dir;
    std::string _prefix;
    std::string _suffix;
    bool _stdout;

    boost::thread* _output_thr;
    boost::mutex _mutex;
    boost::condition _cond;
    std::deque<msg_part> _queue;
};

} // namespace logger
} // namespace modules

SL_REGIST_LOADABLE_CLASS(modules::logger::DefaultLogger);

#endif // SHIBAINU_DEFAULT_LOGGER_H
