/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef SHIBAINU_DEFAULT_WRAPPER_H
#define SHIBAINU_DEFAULT_WRAPPER_H

#include <map>
#include <string>
#include <vector>
#include <boost/regex.hpp>

#include <sl/class_loader/register.hpp>
#include <servlet/Servlet.h>
#include <servlet/ServletContext.h>
#include <servlet/ServletConfig.h>

#include <si/interface/Config.h>
#include <si/interface/ServletWrapper.h>
using namespace si::interface;

#include "DefaultBase.h"

namespace modules {
namespace core {

class DefaultWrapper : virtual public DefaultBase, virtual public ServletWrapper
{
    typedef std::map<std::string, std::string> init_para_map_t;

public :
    /** Constructor */
    DefaultWrapper();

    /** Destructor */
    virtual ~DefaultWrapper();

    virtual void docBase(const std::string& docBase);

    virtual std::string docBase();

    virtual void servletClassPath(const std::string& path);

    virtual std::string servletClassPath();

    virtual void servletClassName(const std::string& name);

    virtual std::string servletClassName();

    virtual void setManager(boost::shared_ptr<Manager> Manager);

    virtual boost::shared_ptr<Manager> getManager();

    virtual void addMapping(const std::string& pattern);

    virtual std::vector<std::string> getMapping();

    virtual bool match(const std::string& pattern) const;

    virtual void addInitParam(const std::string& n, const std::string& v);

    virtual servlet::ServletContext& getServletContext();

    virtual void setServletContext(servlet::ServletContext&);

    virtual time_t invokeTime();

    virtual void loadInstance();

    virtual void unloadInstance();

    virtual servlet::Servlet *instance();

    virtual void init();

    virtual void destroy();

    virtual void service(Connection *p);

    virtual void service(servlet::ServletRequest&, servlet::ServletResponse&);

private :
    boost::shared_ptr<Manager> _manager;
    boost::shared_ptr<servlet::Servlet> _servlet;

    std::string _doc_base;
    std::string _class_path;
    std::string _class_name;
    std::vector<std::string> _mapping_list;
    std::vector<boost::regex> _map_regex_list;
    init_para_map_t _init_para_map;

    servlet::ServletContext* _context;
    servlet::ServletConfig* _config;

    time_t _invoke_time;
};

} // namespace core
} // namespace modules

SL_REGIST_LOADABLE_CLASS(modules::core::DefaultWrapper)

#endif // SHIBAINU_DEFAULT_WRAPPER_H
