/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef SHIBAINU_DEFAULT_VALVECONTEXT_H
#define SHIBAINU_DEFAULT_VALVECONTEXT_H

#include <si/interface/Base.h>
#include <si/interface/Connection.h>
#include <si/interface/Valve.h>
#include <si/interface/ValveContext.h>

namespace modules {
namespace core {

class DefaultValveContext : virtual public si::interface::ValveContext {
public :

    DefaultValveContext(si::interface::Base* base,
                        std::vector<boost::shared_ptr<si::interface::Valve> >& valves)
        : _base(base), _valves(valves), _size(valves.size()), _count(0)
    { }

    virtual ~DefaultValveContext()
    { }

    void setBase(si::interface::Base* base)
    {
        _base = base;
    }

    si::interface::Base* getBase()
    {
        return _base;
    }

    void invokeNext(si::interface::Connection& p)
    {
#ifdef DEBUG
std::cerr << "DefaultValveContext::invokeNext " << _count << std::endl;
#endif
        if (_size > _count) {
            boost::shared_ptr<si::interface::Valve>& ptr = _valves[_count++];
            ptr->invoke(p, *this);
            }
    }

    void set(const std::vector<boost::shared_ptr<si::interface::Valve> >& valves)
    {
        _valves = valves;
    }

private :
    si::interface::Base* _base;
    std::vector<boost::shared_ptr<si::interface::Valve> >& _valves;
    size_t _size;
    size_t _count;
};

} // namespace core
} // namespace modules

#endif // SHIBAINU_DEFAULT_VALVECONTEXT_H

