/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#include <iostream>
#include <boost/shared_ptr.hpp>
using namespace std;
using namespace boost;

#include <si/interface/Service.h>
#include <si/interface/Engine.h>
#include <si/interface/Connection.h>
#include <si/interface/Response.h>
using namespace si::interface;

#include "DefaultServiceValve.h"
using namespace modules::core;

//
// Constructor/Destructor.
//

DefaultServiceValve::DefaultServiceValve()
    : _service(0)
{ }


DefaultServiceValve::~DefaultServiceValve()
{ }


//
// Member functions.
//

void DefaultServiceValve::config(const si::interface::Config& config)
{
    _config = config;
}

Config DefaultServiceValve::config() const
{
    return _config;
}


void DefaultServiceValve::invoke(Connection &connection, ValveContext& context)
{
    if (!_service)
        _service = dynamic_cast<Service*>(context.getBase());

    if (!_logger)
        _logger = _service->getLogger();

    //
    // Engine  Pipiline::invoke ¹Ԥ.
    //
    shared_ptr<Engine> target = _service->getEngine();
    if (target) {
        target->invoke(connection);
        return;
    }

    std::string msg("\"Engine\" doesen't exists.");
    _logger->log(msg, Logger::WARN_LOG);
    throw std::runtime_error(msg);
}
