/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef SHIBAINU_DEFAULT_SERVICE_H
#define SHIBAINU_DEFAULT_SERVICE_H

#include <set>
#include <string>
#include <vector>
#include <sl/class_loader/register.hpp>

#include <si/interface/Config.h>
#include <si/interface/Service.h>

#include "DefaultBase.h"

namespace modules {
namespace core {

/**
 * Engine 󥹥󥹤Ȥ³ Connector 륯饹Ǥ
 * ʣϿ줿 Connector ¹Ԥ˥ꥯȤ
 * Engine 󥹥󥹤˰Ϥޤ
 * DefaultBase 饹ڤӡ interface::Service 󥿡ե
 * Ѿޤ
 */
class DefaultService
  : virtual public DefaultBase, virtual public si::interface::Service
{

    typedef std::set<boost::shared_ptr<si::interface::Connector> >
        connector_list_t;

public :
    DefaultService();

    ~DefaultService();

    virtual void
    addConnector(boost::shared_ptr<si::interface::Connector> connector);

    virtual std::set<boost::shared_ptr<si::interface::Connector> >
    getConnectorList();

    virtual void setEngine(boost::shared_ptr<si::interface::Engine> engine);

    boost::shared_ptr<si::interface::Engine> getEngine() const;

    /**
     * Logger / Connector / Engine νԤʤޤ
     * ޤȤΥдؿ򥹥åɼ¹ԤConnector ͳǤ
     * 饤ȤΥԤޤ
     *
     * δؿ¹ˤ setConnectorڤsetEngine ؿˤ
     * Connector / Engine ϿԤʤƤɬפޤ
     */
    virtual void init();

    /**
     * Logger / Connector / Engine νλԤʤޤ
     *
     */
    virtual void destroy();

private :
    void loadValves(const std::vector<si::interface::Config>& clist);

    std::string _debug;

    boost::shared_ptr<si::interface::Engine> _engine;
    connector_list_t _connector_list;
};

} // namespace core
} // namespace modules

SL_REGIST_LOADABLE_CLASS(modules::core::DefaultService)

#endif // SHIBAINU_DEFAULT_SERVICE_H
