/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef SHIBAINU_DEFAULT_SERVER_H
#define SHIBAINU_DEFAULT_SERVER_H

#include <set>

#include <sl/class_loader/register.hpp>
#include <si/interface/Server.h>
#include <si/interface/Connector.h>
#include <si/interface/Engine.h>
#include <si/interface/Host.h>
#include <si/interface/Context.h>

#include "DefaultBase.h"

namespace modules {
namespace core {

class DefaultServer : virtual public DefaultBase, public si::interface::Server {

    typedef std::set<boost::shared_ptr<si::interface::Service> > service_list_t;

public :
    /** Constructor */
    DefaultServer();

    /** Destructor */
    ~DefaultServer();

    virtual void setService(boost::shared_ptr<si::interface::Service> context);

    virtual boost::shared_ptr<si::interface::Service>
    getService(const std::string& name);

    virtual void init();

    virtual void destroy();

    virtual void service(si::interface::Connection* p);

private :
    std::string _home;
    std::string _debug;
    service_list_t _service_list;

    boost::shared_ptr<si::interface::Service> _service;
};

} // namespace core
} // namespace modules

SL_REGIST_LOADABLE_CLASS(modules::core::DefaultServer)

#endif // SHIBAINU_DEFAULT_SERVER_H
