/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef SHIBAINU_DEFAULT_PIPELINE_H
#define SHIBAINU_DEFAULT_PIPELINE_H

#include <si/interface/Config.h>
#include <si/interface/Pipeline.h>
#include <si/interface/Valve.h>

#include "DefaultValveContext.h"

namespace modules {
namespace core {

class DefaultPipeline : virtual public si::interface::Pipeline {
public :
    DefaultPipeline() { }

    virtual ~DefaultPipeline() { }

    void setBase(si::interface::Base* base)
    {
        _base = base;
    }

    si::interface::Base* getBase()
    {
        return _base;
    }

    void addValve(boost::shared_ptr<si::interface::Valve>& valve)
    {
        _valves.push_back(valve);
    }

    std::vector<boost::shared_ptr<si::interface::Valve> > getValve() const
    {
        return _valves;
    }

    void removeValve(boost::shared_ptr<si::interface::Valve>& valve)
    {
        _valves.erase(std::remove(_valves.begin(), _valves.end(), valve),
                      _valves.end());
    }

        virtual void setValveContext(boost::shared_ptr<si::interface::ValveContext>&)
    { }

        virtual boost::shared_ptr<si::interface::ValveContext> getValveContext() const
    {
        return boost::shared_ptr<si::interface::ValveContext>();
    }

    void invoke(si::interface::Connection& p)
    {
#ifdef DEBUG
std::cerr << "DefaultPipeline::invoke " << _valves.size() << std::endl;
#endif
        if (_valves.empty())
            return;

        DefaultValveContext context(_base, _valves);
//            context.setBase(getBase());
//            context.set(_valves);
        context.invokeNext(p);
    }

private :
    si::interface::Base* _base;
    std::vector<boost::shared_ptr<si::interface::Valve> > _valves;
};

} // namespace core
} // namespace modules

#endif // SHIBAINU_DEFAULT_PIPELINE_H

