/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef SHIBAINU_DEFAULT_MANAGER_H
#define SHIBAINU_DEFAULT_MANAGER_H

#include <map>
#include <string>
#include <boost/thread/mutex.hpp>
#include <boost/thread/thread.hpp>
#include <sl/class_loader/register.hpp>
#include <si/interface/Manager.h>

#include "DefaultBase.h"

namespace modules {
namespace core {

class DefaultManager
  : virtual public DefaultBase, virtual public si::interface::Manager
{
    struct SessionInfo {
        servlet::http::HttpSession* session;
        time_t access;

        SessionInfo(servlet::http::HttpSession* s, time_t a)
          : session(s), access(a)
        { }

        bool operator<(const SessionInfo& r)
        {
            return session->getId() < r.session->getId();
        }
    };

    typedef std::map<std::string, SessionInfo> session_map_t;

    typedef std::vector<servlet::http::HttpSessionListener*>
                                            session_listener_list_t;
    typedef std::vector<servlet::http::HttpSessionAttributeListener*>
                                            session_attr_listener_list_t;
    typedef std::vector<servlet::http::HttpSessionActivationListener*>
                                            session_acti_listener_list_t;

public :
    DefaultManager();

    ~DefaultManager();

    servlet::http::HttpSession *createSession(int alive);

    void deleteSession();

    bool touchSession(servlet::http::HttpSession* s);

    bool touchSession(const std::string& id);

    std::vector<servlet::http::HttpSession*> getSessionList();

    servlet::http::HttpSession* getSession(const std::string& id);

    virtual void addSessionListener(servlet::http::HttpSessionListener* l);

    virtual void
    addSessionAttributeListener(servlet::http::HttpSessionAttributeListener* l);

    virtual void
    addSessionActivationListener(servlet::http::HttpSessionActivationListener* l);

    void init();

    void destroy();

private :
    void load(const std::string& dir);

    void save(const std::string& dir);

    session_map_t _session_map;
    boost::thread* _delete_thread;
    boost::mutex _mutex;

    session_listener_list_t _ss_listeners;
    session_attr_listener_list_t _at_listeners;
    session_acti_listener_list_t _ac_listeners;
};

} // namespace core
} // namespace modules

SL_REGIST_LOADABLE_CLASS(modules::core::DefaultManager)

#endif // SHIBAINU_DEFAULT_MANAGER_H
