/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#include <iostream>
#include <boost/bind.hpp>
#include <boost/lexical_cast.hpp>
#include <boost/thread/mutex.hpp>
#include <boost/random.hpp>
using namespace std;
using namespace boost;

#include "DefaultManager.h"
#include <si/interface/Config.h>
#include <si/interface/Context.h>
#include <si/interface/Host.h>
#include <si/interface/Logger.h>
#include <si/core/HttpSessionImpl.h>
using namespace si::interface;
using namespace si::core;
using namespace modules::core;



//
// Constructor/Destructor.
//

DefaultManager::DefaultManager()
{ 
}


DefaultManager::~DefaultManager()
{
}


//
// Member functions.
//

void DefaultManager::init()
{
    boost::mutex::scoped_lock lock(_mutex);
    if (!getLogger())
        setLogger(getParent()->getLogger());

    getLogger()->log("DefaultManager::init - Beginning of initialization",
                     Logger::DEBUG_LOG);
    _available = true;

    _delete_thread =
        new boost::thread(boost::bind(
                            &DefaultManager::deleteSession, boost::ref(*this)));
}

void DefaultManager::destroy()
{
    boost::mutex::scoped_lock lock(_mutex);
    if (!_available)
        return;
    _available = false;
    lock.unlock();

    _delete_thread->join();
    delete _delete_thread;

    lock.lock();
    session_map_t::iterator i = _session_map.begin();
    for (; i != _session_map.end(); i++) {
        /* åФꥹʡΥдؿư. */
#if 0
        servlet::http::HttpSessionEvent e(i->second.session);
        session_listener_list_t::iterator j = _ss_listeners.begin();
        for (; j != _ss_listeners.end(); j ++)
            (*j)->sessionDestroyed(e);
#endif
        delete i->second.session;
    }
    getLogger()->log("DefaultManager::destroy Beginning of termination.",
                     Logger::DEBUG_LOG);
}


//
// private ------------------------------------------------------------------
//

void DefaultManager::load(const std::string &work_dir)
{

}


void DefaultManager::save(const std::string &work_dir)
{

}


servlet::http::HttpSession *DefaultManager::createSession(int time)
{
    static boost::mt19937 g;
    static boost::uniform_int<> d(0x30, 0x7a);
    static boost::variate_generator<boost::mt19937, boost::uniform_int<> > r(g, d);
    static const std::string SessionId =
               "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
    int _session_time = 1;

    time_t t;

    if (time)
        t = time * 60 + ::time(0);
    else
        t = _session_time ? _session_time * 60 + ::time(0) : 0;

    std::stringstream ss;
    for (int c = 0; c < 32;) {
        char n = static_cast<char>(r());
        if (SessionId.find(n) != std::string::npos) {
            ss << n;
            ++c;
        }
    }

    boost::mutex::scoped_lock lock(_mutex);

    HttpSessionImpl *s = new HttpSessionImpl(ss.str());
    s->setMaxInactiveInterval(time ? time : _session_time);
    _session_map.insert(session_map_t::value_type(ss.str(), SessionInfo(s, t)));

    lock.unlock();

    getLogger()->log("Manager :Create new session object. ID is "
                     "'"+ s->getId()+ "'", Logger::DEBUG_LOG);

    //
    // åФꥹʡΥдؿư.
    //
    servlet::http::HttpSessionEvent e(*s);
    session_listener_list_t::iterator i = _ss_listeners.begin();
    for (; i != _ss_listeners.end(); i++)
        (*i)->sessionCreated(e);

    //
    // å°Фꥹʡ HttpSessionImpl ǵư뤿ᡢ
    // ꥹʡ HttpSessionImpl Ϥ.
    //
    session_attr_listener_list_t::iterator a = _at_listeners.begin();
    for (; a != _at_listeners.end(); a++)
        s->setAttributeListener(*a);

    return s;
}

void DefaultManager::deleteSession()
{
#ifdef DEBUG
    std::cerr << "DefaultManager::deleteSession Enter" << std::endl;
#endif

    boost::mutex::scoped_lock lock(_mutex);
    lock.unlock();

    while (_available) {
        sleep(1);
        time_t time = ::time(0);

        lock.lock();
        session_map_t::iterator i = _session_map.begin();
        for (; i != _session_map.end(); ) {
#ifdef DEBUG
std::cerr << "CurrentTime:" << time << std::endl;
std::cerr << "SessionTime:" << i->second.access << std::endl;
#endif
            // ֤вᤷơġȤƤʤкޤ
            if (i->second.access < time) {
                servlet::http::HttpSession *s = i->second.session;
                _session_map.erase(i++);
#ifdef DEBUG
std::cerr << "Erase Session:" << s->getId() << std::endl;
#endif
                /* åФꥹʡΥдؿư. */
                servlet::http::HttpSessionEvent e(*s);
                session_listener_list_t::iterator i = _ss_listeners.begin();
                for (; i != _ss_listeners.end(); i ++)
                    (*i)->sessionDestroyed(e);

                delete s;
            } else
                ++i;
        }
        lock.unlock();
    }
#ifdef DEBUG
    std::cerr << "DefaultManager::deleteSession Exit" << std::endl;
#endif
}

std::vector<servlet::http::HttpSession *> DefaultManager::getSessionList()
{
    std::vector<servlet::http::HttpSession *>   session_list;
#if 0
    // åˡߺǽʥåޤ
    deleteSession();

    boost::mutex::scoped_lock lock(_mutex);

    session_map_t::iterator i = _session_map.begin();
    for (; i != _session_map.end(); i++)
        session_list.push_back(i->second.session);

    for (i = _session_map.begin(); i != _session_map.end(); i++) {
        getLogger()->log("Manager :ID of an effective session is '" +
                         i->second.session->getId() + "'.", Logger::DEBUG_LOG);
    }
#endif
    return session_list;
}

servlet::http::HttpSession* DefaultManager::getSession(const std::string& id)
{
    boost::mutex::scoped_lock lock(_mutex);

    session_map_t::iterator i = _session_map.find(id);
    if (i == _session_map.end())
        return 0;

    SessionInfo& info(i->second);
    info.access = info.session->getMaxInactiveInterval() * 60 + ::time(0);
    return info.session;
}

bool DefaultManager::touchSession(servlet::http::HttpSession *s)
{
#if 0
    boost::mutex::scoped_lock lock(_mutex);

    // å¸ߤͭ
    session_map_t::iterator i = _session_map.find(s);
    if (i != _session_map.end() && s->getMaxInactiveInterval()) {
        _session_map.erase(i);
        _session_map.insert(session_map_t::value_type(s,
                            s->getMaxInactiveInterval() * 60 + ::time(0)));
        return true;
    }
#endif
    return false;
}

bool DefaultManager::touchSession(const std::string& id)
{
#if 0
    boost::mutex::scoped_lock lock(_mutex);

    // å¸ߤͭ
    session_map_t::iterator i = _session_map.find(id);
    if (i != _session_map.end() && i->second.session->getMaxInactiveInterval())
    {
        _session_map.erase(i);
        _session_map.insert(session_map_t::value_type(id, 
                SessionInfo(i->second.session,
                i->second.session->getMaxInactiveInterval() * 60 + ::time(0))));
        return true;
    }
#endif
    return false;
}

void DefaultManager::addSessionListener(servlet::http::HttpSessionListener* l)
{
    _ss_listeners.push_back(l);
}

void DefaultManager::addSessionAttributeListener(servlet::http::HttpSessionAttributeListener* l)
{
    _at_listeners.push_back(l);
}

void DefaultManager::addSessionActivationListener(servlet::http::HttpSessionActivationListener* l)
{
    _ac_listeners.push_back(l);
}
