/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#include <iostream>
#include <boost/shared_ptr.hpp>
using namespace std;
using namespace boost;

#include "DefaultHostValve.h"
#include <si/interface/Connection.h>
#include <si/interface/Context.h>
#include <si/interface/Host.h>
#include <si/interface/Logger.h>
#include <si/interface/Request.h>
#include <si/interface/Response.h>
using namespace si::interface;
using namespace modules::core;


//
// Constructor/Destructor.
//

DefaultHostValve::DefaultHostValve()
    : _host(0)
{ }


DefaultHostValve::~DefaultHostValve()
{ }

void DefaultHostValve::config(const si::interface::Config& config)
{
    _config = config;
}

Config DefaultHostValve::config() const
{
    return _config;
}


void DefaultHostValve::invoke(Connection& connection, ValveContext& context)
{
    if (!_host)
        _host = dynamic_cast<Host*>(context.getBase());

    if (!_logger)
        _logger = _host->getLogger();

    _logger->log("HostValue :invoke", Logger::DEBUG_LOG);

    /*
     * uri 饳ƥȥѥȴФơ
     * ޥå륳ƥȥѥݻ Context 򸡺.
     *
     * ǤΥƥȥѥȤ URI(abs_path) Ƭ '/' 
     *  '/' (¸ߤʤϥѥνλ)ޤǤʸ.
     */
    std::string context_path;
    string::size_type pos = connection.request().uri().find("/", 1);
    if (pos == std::string::npos)
        context_path = connection.request().uri();
    else
        context_path = connection.request().uri().substr(0, pos);

    shared_ptr<Context> target = _host->getContext(context_path);
    if (target) {
        connection.response().setContext(target);
        target->invoke(connection);
        return;
    }

    /*
     * uri  '/' Ƕڤ줿ƥȥѥʤ
     * ޤϥޥå Context ¸ߤʤ
     * ROOT ΥƥȤ򸡺.
     * 
     *  ROOT ѤΥƥȥѥ conf/server.xml ѹǽǤ뤬
     * ǤϤΤ褦̵̰̣ϤƤʤȤƽԤʤ.
     */
    target = _host->getContext("/");
    if (target) {
        connection.response().setContext(target);
        target->invoke(connection);
        return;
    }

    std::string msg("\"Context\" doesen't exists.");
    _logger->log(msg, Logger::WARN_LOG);
    throw std::runtime_error(msg);
}
