/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef SHIBAINU_DEFAULT_HOST_H
#define SHIBAINU_DEFAULT_HOST_H

#include <list>
#include <string>
#include <boost/thread.hpp>
#include <boost/thread/condition.hpp>
#include <sl/class_loader/register.hpp>

#include <si/interface/Config.h>
#include <si/interface/Host.h>
using namespace si::interface;

#include "DefaultBase.h"

namespace modules {
namespace core {

/**
 * Engine 󥹥󤫤žˤꥯȤνԤʤ
 *  Host Ȥ¸ߤ۲¸ߤʣ Context Ŭڤ
 * Context 򤷡ꥯȤѤޤ.
 */
class DefaultHost : public DefaultBase, public Host
{
    typedef std::vector<boost::shared_ptr<Context> > context_list_t;

public :
    DefaultHost();

    ~DefaultHost();

    virtual void setConfDir(const std::string& dir);

    virtual std::string getConfDir();

    virtual void setWorkDir(const std::string& dir);

    virtual std::string getWorkDir();

    virtual void appBase(const std::string& appBase);

    virtual std::string appBase();

    virtual void setDefaultContext(boost::shared_ptr<Context> context);

    virtual boost::shared_ptr<Context> getDefaultContext();

    virtual void setContext(boost::shared_ptr<Context>& context);

    virtual boost::shared_ptr<Context> getContext(const std::string& path);

    virtual std::vector<boost::shared_ptr<Context> > getContextSet();

    virtual void setManager(boost::shared_ptr<Manager> manager);

    virtual boost::shared_ptr<Manager> getManager();

    virtual void init();

    virtual void destroy();

private :
    /**
     * WEBץꥱ롼Ȱʲ'äݤǥ쥯ȥ'
     * Ф Context XML եޤ.
     */
    bool createContextXML(const std::string& path);

    /**
     * ƥȥե饰XMLեɤ߹.
     */
    boost::shared_ptr<Context>
    loadFromFragmentContextXML(const std::string& path);

    /**
     * WEBץꥱ롼Ȱʲ˴˥ƥXML¸ߤ뤫
     * ֤ޤ.
     * @param    file    ƥXMLե̾.
     * @return        ե¸̵ͭ.
     */
    bool findContextFlagmentXML(const std::string& file);

    /**
     * ƥȥե饰XML `file` + ".xml" ȤƽϤޤ.
     * @param    file    XMLե̾.
     */
    bool outputContextXML(const std::string& file);

    /**
     *  time 򥤥󥿡ХȤƿץꥱɲäƻ뤷ޤ.
     */
    void deployCheck();

    /**
     *  config  class_name  class_path Ǥ򸵤
     * Context 󥹥󥹤ޤ.
     * ޤconfig  class_name/class_path ¸ߤʤ
     * "modules/lib/DefaultContext"ޤ.
     *
     * @param    config        class_name/class_pathǤ Config.
     */
    boost::shared_ptr<Context> loadContext(const si::interface::Config& c);

    void loadContexts(const std::vector<si::interface::Config>& c);

    void unloadContext(boost::shared_ptr<Context>& p);

    void loadValves(const std::vector<si::interface::Config>& c);

    std::string _app_base;
    std::string _deploy_xml;
    std::string _conf_dir;
    std::string _work_dir;

    boost::shared_ptr<Manager> _manager;
    boost::shared_ptr<Context> _default_context;
    context_list_t _context_list;

    time_t _deploy_interval;
    volatile bool _deploy;
    boost::thread* _deploy_thread;
    boost::mutex _deploy_mutex;
    boost::condition _deploy_cond;

    bool _is_load_logger;
    bool _is_load_realm;
};

} // namespace core
} // namespace modules

SL_REGIST_LOADABLE_CLASS(modules::core::DefaultHost)

#endif // SHIBAINU_DEFAULT_HOST_H
