/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#include <iostream>
#include <boost/shared_ptr.hpp>
using namespace std;
using namespace boost;

#include <sl/java/lang/ClassLoader.h>

#include "DefaultEngineValve.h"

#include <si/interface/Logger.h>
#include <si/interface/Engine.h>
#include <si/interface/Host.h>
#include <si/interface/Connection.h>
using namespace si::interface;
using namespace modules::core;


//
// Constructor/Destructor.
//

DefaultEngineValve::DefaultEngineValve()
    : _engine(0)
{ 
}


DefaultEngineValve::~DefaultEngineValve()
{
}

void DefaultEngineValve::config(const si::interface::Config& config)
{
    _config = config;
}

Config DefaultEngineValve::config() const
{
    return _config;
}

void DefaultEngineValve::invoke(Connection& connection, ValveContext& context)
{
    if (!_engine)
        _engine = dynamic_cast<Engine*>(context.getBase());

    if (!_logger)
        _logger = _engine->getLogger();

    shared_ptr<Host> target = _engine->getHost(connection.serverHost());
    if (target) {
        target->invoke(connection);
        return;
    }

    std::string msg("\"DefaultHost\" doesen't exists.");
    _logger->log(msg, Logger::WARN_LOG);
    throw std::runtime_error(msg);
}
