/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef SHIBAINU_DEFAULT_ENGINE_H
#define SHIBAINU_DEFAULT_ENGINE_H

#include <set>
#include <string>
#include <sl/class_loader/register.hpp>
#include <si/interface/Config.h>
#include <si/interface/Engine.h>
#include <si/interface/Valve.h>
#include <si/interface/Loader.h>

#include "DefaultBase.h"

namespace modules {
namespace core {

/**
 * Service λ Connector ΥꥯȤ
 * åȤȤʤ Host ؤžԤʤޤ
 */
class DefaultEngine
        : virtual public DefaultBase,virtual public si::interface::Engine
{
    typedef std::set<boost::shared_ptr<si::interface::Host> > host_list_t;

public :
    /** Constructor */
    DefaultEngine();

    /** Destructor */
    virtual ~DefaultEngine();

    virtual void setHost(boost::shared_ptr<si::interface::Host> host);

    virtual boost::shared_ptr<si::interface::Host> getDefaultHost();

    virtual boost::shared_ptr<si::interface::Host> getHost(const std::string& name);

    virtual void setDefaultContext(boost::shared_ptr<si::interface::Context> context);

    virtual boost::shared_ptr<si::interface::Context> getDefaultContext();

    virtual void init();

    virtual void destroy();

private :
    boost::shared_ptr<si::interface::Context> _context;

    void loadHosts(const std::vector<si::interface::Config>& c);
    void loadHost(const si::interface::Config& c);
    void loadValves(const std::vector<si::interface::Config>& c);

    host_list_t _host_list;
    std::string _default_host;
};

} // namespace core
} // namespace modules

SL_REGIST_LOADABLE_CLASS(modules::core::DefaultEngine)

#endif // SHIBAINU_DEFAULT_ENGINE_H
