/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef SHIBAINU_DEFAULT_CONTEXT_VALVE_H
#define SHIBAINU_DEFAULT_CONTEXT_VALVE_H

#include <string>
#include <sl/class_loader/register.hpp>

#include <si/interface/Valve.h>
#include <si/interface/ValveContext.h>
#include <si/interface/Context.h>
#include <si/interface/Config.h>

namespace modules {
namespace core {

class DefaultContextValve : virtual public si::interface::Valve {
public :
    /** Constructor */
    DefaultContextValve();

    /** Destructor */
    virtual ~DefaultContextValve();

    virtual void config(const si::interface::Config& c);

    virtual si::interface::Config config() const;

    void invoke(si::interface::Connection& p, si::interface::ValveContext& context);

private :
    void service(si::interface::Connection& p, si::interface::Context& ctx,
                 si::interface::Logger& logger);

    bool authorization(si::interface::Connection& p,
                       si::interface::Context& ctx, const std::string &auth);
    void auth_require_response(si::interface::Connection& p,
                               const string& auth, const std::string& realm_name);

    si::interface::Config _config;
    si::interface::Context* _context;
    boost::shared_ptr<si::interface::Logger> _logger;
    std::string _path;

    std::string _security_constraint_url;
    bool _security_existance_judged;
};

} // namespace core
} // namespace modules

SL_REGIST_LOADABLE_CLASS(modules::core::DefaultContextValve)

#endif // SHIBAINU_DEFAULT_CONTEXT_VALVE_H
