/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef SHIBAINU_DEFAULT_CONTEXT_H
#define SHIBAINU_DEFAULT_CONTEXT_H

#include <list>
#include <string>
#include <vector>
#include <boost/thread.hpp>
#include <boost/thread/condition.hpp>
#include <boost/regex.hpp>
#include <sl/java/util/EventListener.h>
#include <sl/class_loader/register.hpp>

#include <si/interface/Config.h>
#include <si/interface/Context.h>
#include <si/interface/ServletWrapper.h>
#include <si/core/FilterChainImpl.h>
#include <si/core/ServletContextImpl.h>
#include <si/core/LibraryLoader.h>
#include <si/webxml/ApplicationConfig.h>

#include "DefaultBase.h"

namespace modules {
namespace core {

class DefaultContext
        : virtual public DefaultBase, virtual public si::interface::Context
{
    typedef std::vector<boost::shared_ptr<si::interface::ServletWrapper> >
        wrapper_list_t;
    typedef std::vector<servlet::FilterConfig*> filter_config_list_t;
    typedef std::vector<servlet::Filter*> filter_list_t;

    typedef std::vector<boost::shared_ptr<sl::java::util::EventListener> >
        listener_list_t;

    typedef std::vector<
        boost::shared_ptr<servlet::http::HttpSessionListener>
    > ses_listeners_t;
    typedef std::vector<
        boost::shared_ptr<servlet::http::HttpSessionAttributeListener>
    > ses_attr_listeners_t;
    typedef std::vector<
        boost::shared_ptr<servlet::ServletContextListener>
    > ctx_listeners_t;
    typedef std::vector<
        boost::shared_ptr<servlet::ServletContextAttributeListener>
    > ctx_attr_listeners_t;
    typedef std::vector<
        boost::shared_ptr<servlet::ServletRequestListener>
    > req_listeners_t; 
    typedef std::vector<
        boost::shared_ptr<servlet::ServletRequestAttributeListener>
    > req_attr_listeners_t;

public :
    /** Constructor */
    DefaultContext();

    /** Destructor */
    ~DefaultContext();

    void init();

    void destroy();

    void path(const std::string& path);

    std::string path() const;

    void docBase(const std::string& paht);

    std::string docBase() const;

    void setWorkDir(const std::string &dir);

    std::string getWorkDir() const;

    bool match(const std::string& context_path) const;

    time_t invokeTime();

    void setManager(const boost::shared_ptr<si::interface::Manager>& manager);

    boost::shared_ptr<si::interface::Manager> getManager() const;

    void setWrapper(boost::shared_ptr<si::interface::ServletWrapper> wrapper);

    boost::shared_ptr<si::interface::ServletWrapper>
    getWrapper(const std::string& path) const;

    boost::shared_ptr<si::interface::ServletWrapper>
    getNamedWrapper(const std::string& path) const;

    void addFilter(boost::shared_ptr<servlet::Filter> filter);

    std::vector<boost::shared_ptr<servlet::Filter> > getFilter() const;

    std::vector<boost::shared_ptr<sl::java::util::EventListener> >
    getListeners() const;

    servlet::FilterChain& getFilterChain();

    servlet::ServletContext& getServletContext();

    std::list<std::string> welcomeFileList() const;

    std::string getErrorPage(int code) const;

    std::string getErrorPage(const std::string& e) const;

    si::webxml::jsp_config getJspConfig() const;

    std::vector<si::webxml::security_constraint>
    getSecurityConstraint() const;

    si::webxml::login_config getLoginConfig() const;

    si::webxml::session_config getSessionConfig() const;

private :

    /**
     * Context ˵Ҥ줿°ͤɤ߹ߤޤ.
     * ¸ߤʤͤˤϥǥեȤͤꤵޤ.
     */
    void setupAttribute();

    /**
     * web.xml ˵Ҥ줿 Filter 饹ƥɤޤ.
     */
    void loadAllFilter();

    /**
     * ˥ɺѤߤ Filter 饹Υ󥹥󥹤ƥɤޤ.
     */
    void unloadAllFilter();

    /**
     * web.xml ˵Ҥ줿 Listener 饹ƥɤޤ.
     */
    void loadAllListener();

    /**
     * ˥ɺѤߤ Listener 饹Υ󥹥󥹤
     * ɤޤ.
     */
    void unloadAllListener();

    /**
     * web.xml ˵Ҥ줿 Servlet 饹Ф
     * si::interface::ServletWrapper ƥɤޤ.
     */
    void loadAllWrapper();

    /**
     *  name ˻ꤵ줿 si::interface::ServletWrapper 饹ޤ.
     *
     * @paran    name    si::interface::ServletWrapper 饹̾.
     * @return    ServletWrapper 饹󥹥.
     */
    boost::shared_ptr<si::interface::ServletWrapper>
    loadWrapper(const std::string& name);

    /**
     *  name ˻ꤵ줿 si::interface::ServletWrapper 饹
     * ɤޤ.
     *
     * @paran    name    si::interface::ServletWrapper 饹󥹥.
     */
    void unloadWrapper(boost::shared_ptr<si::interface::ServletWrapper>& p);


    /**
     *  config  class_name  class_path Ǥ򸵤
     * si::interface::Manager 󥹥󥹤ޤ.
     * ޤconfig  class_name/class_path ¸ߤʤ
     * "modules/lib/DefaultContext"ޤ.
     *
     * @param    config        class_name/class_pathǤ Config.
     */
    void loadManager(const si::interface::Config& c);

    /**
     *  config  class_name  class_path Ǥ򸵤
     * Valve 󥹥󥹤ޤ.
     *
     * @param    config        class_name/class_pathǤ Config.
     */
    void loadValves(const std::vector<si::interface::Config>& c);

    /**
     * ServletContext κǡԤޤ.
     * ServletContext Υ󥹥󥹤κڤӡ
     * web.xml  context-param  mime-type Ԥޤ.
     * 줿 ServletContext Υ󥹥󥹤 _servlet_context 
     * ꤵޤ.
     */
    void createServletContext();

    /**
     *  time 򥤥󥿡ХȤ
     * si::interface::ServletWrapper::invokeTime 
     * ֥ȥեӤɤμ¹ԤȽꤷޤ.
     * ɤɬפȽǤ
     * si::interface::ServletWrapper::unloadInstance ڤӡ
     * si::interface::ServletWrapper::loadInstance ˼¹Ԥޤ.
     */
    void reloadCheck(void);

    std::string    _home;
    std::string    _doc_base;
    std::string    _path;
    std::string    _reloadable;
    time_t        _invoke_time;
    time_t        _reload_interval;

    boost::regex _path_regex;

    boost::shared_ptr<si::interface::Manager> _manager;
    wrapper_list_t _wrapper_list;
    ctx_listeners_t _ctx_listeners;
    req_listeners_t _req_listeners;
    ses_listeners_t _ses_listeners;
    ctx_attr_listeners_t _ctx_attr_listeners;
    req_attr_listeners_t _req_attr_listeners;
    ses_attr_listeners_t _ses_attr_listeners;

    std::vector<std::string> _listener_names;
    std::vector<std::string> _filter_names;

    filter_config_list_t _filter_config_list;
    filter_list_t _filter_list;
    si::core::FilterChainImpl* _filter_chain;
    si::core::ServletContextImpl* _servlet_context;
    si::core::LibraryLoader _libloader;
    si::webxml::ApplicationConfig* _web_xml;

    volatile bool _is_service;
    volatile bool _reload;
    boost::thread* _reload_thread;
    boost::condition _reload_cond;
    boost::mutex _reload_mutex;
    boost::mutex _service_mutex;
};

} // namespace core
} // namespace modules

SL_REGIST_LOADABLE_CLASS(modules::core::DefaultContext);


#endif // SHIBAINU_DEFAULT_CONTEXT_H
