/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: SSLConnection.h,v 1.17 2008/03/01 03:37:10 cvsuser Exp $
 */

#ifndef __SSL_CONNECTION_H__
#define __SSL_CONNECTION_H__

#include <iostream>
#include <string>
#include <openssl/ssl.h>

#include <sl/io/fdstream.h>
#include <sl/net/http/reader.h>
#include <sl/net/http/request.h>
#include <sl/net/http/writer.h>

#include "interface/Connection.h"
using namespace si::interface;

#include "SSLRequest.h"
#include "SSLResponse.h"

// namespace si { namespace modules {

	class ssl_reader : public io::callback_function {
	public :
		ssl_reader(SSL* ssl) : _ssl(ssl) { }

		int operator()(int, char* buffer, size_t size)
		{
			return SSL_read(_ssl, buffer, size);
		}

	private :
		SSL*	_ssl;
	};

	class ssl_writer : public io::callback_function {
	public :
		ssl_writer(SSL* ssl) : _ssl(ssl) { }

		int operator()(int, char* buffer, size_t size)
		{
			return SSL_write(_ssl, buffer, size);
		}

	private :
		SSL*	_ssl;
	};

	class SSLConnector;

	class SSLConnection : public si::interface::Connection {
	public :
		SSLConnection(SSLConnector *parent, int sock);

		virtual ~SSLConnection();

		bool operator!();

		Request &request();

		Response &response();

		bool init();

		void close();

		void flush();

		void flushBody();

		void flushHeader();

		bool available() const;

		virtual std::string targetHost();

		virtual std::string localHost() const;

		virtual std::string localAddr() const;

		virtual int localPort() const;

		virtual std::string remoteHost() const;

		virtual std::string remoteAddr() const;

		virtual int remotePort() const;

		virtual std::string serverHost() const;

		virtual std::string serverAddr() const;

		virtual int serverPort() const;

        void certificate_file(const std::string &file);

        void private_key_file(const std::string &file);

        void ssl_pre_init();

	private :

		void wait();
		bool server_info(int sock);
		bool remote_info(int sock);
		bool local_info(int sock);
		void gzip_encode(std::string &content);

		SSLConnector *	_parent;
		SSLRequest	 	_request;
		SSLResponse		_response;

        io::iofdstream			_iostream;
		ssl_reader *			_reader;
		ssl_writer *			_writer;
		sl::net::http::request	_real_msg;

		volatile bool	_available;
		volatile bool	_reading;
		volatile bool	_thread_loop;
		int				_accept_socket;
		int				_socket;
		int				_timeout;
		bool			_compress;
		bool			_chunked;

		bool			_lookup;
		std::string		_local_name;
		std::string		_local_addr;
		int				_local_port;
		std::string		_remote_name;
		std::string		_remote_addr;
		int				_remote_port;
		std::string		_server_name;
		std::string		_server_addr;
		int				_server_port;

		boost::thread*	_wait_thread;

		SSL *			_ssl;
		SSL_CTX *		_ctx;
	};

// } } // namespace si::modules

#endif //
