/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#include <sys/types.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <netinet/in.h>
#include <unistd.h>

#include "LaSSLConnection.h"
using namespace modules::connector;


//
// Constructor/Destructor
//
LaSSLConnection::LaSSLConnection()
{ }


LaSSLConnection::~LaSSLConnection()
{ }



//
// Operators.
//


//
// Member functions.
//

bool LaSSLConnection::init(bool lookup)
{
    LaConnection::_request.init(this, sl::ssl_connection::request());
    LaConnection::_response.init(this, sl::ssl_connection::response());

    _lookup = lookup;

    remote_info(sl::ssl_connection::ref_to_socket().descriptor());
    server_info(sl::ssl_connection::ref_to_socket().descriptor());
    local_info (sl::ssl_connection::ref_to_socket().descriptor());

    return true;
}


std::string LaSSLConnection::scheme() const
{
    return "https";
}


sl::http::http_response_writer& LaSSLConnection::writer()
{
    return sl::ssl_connection::writer();
}
