/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef LA_RESPONSE_H
#define LA_RESPONSE_H

#include <string>
#include <vector>
#include <boost/shared_ptr.hpp>
#include <servlet/http/Cookie.h>
#include <sl/inet/http_response.hpp>

#include <si/interface/Context.h>
#include <si/interface/Response.h>

namespace modules {
namespace connector {

class LaConnection;

class LaResponse : public si::interface::Response {
public :
    LaResponse();

    ~LaResponse();

    void init(LaConnection* parent, sl::http::http_response& res);

    void protocol(const std::string& protocol);

    void status(int code, const std::string& msg);

    void header(const std::string& n, const std::string& v);

    void content(const std::string& content);

    void flush();

    void flushHeader();

    void flushBody();

    void cleanup();

    std::ostream& copy_to(std::ostream &);

    std::istream& copy_from(std::istream &);

    void setContext(const boost::shared_ptr<si::interface::Context>& c);

    boost::shared_ptr<si::interface::Context> getContext() const;

    std::string text();

    std::string content();

    virtual void setContentType(const std::string& s);

    virtual void setContentLength(int i);

    virtual std::string getCharacterEncoding();

    virtual std::string getContentType();

    virtual void setContent(const std::string& s);

    virtual void addCookie(const servlet::http::Cookie& c);

    virtual void addHeader(const std::string& s, const std::string& v);

    virtual bool containsHeader(const std::string& s);

    virtual void eraseHeader(const std::string &);

    virtual void sendError(int sc);

    virtual void sendError(int sc, const std::string& s);

    virtual void sendRedirect(const std::string& s);

    virtual void setHeader(const std::string& s, const std::string& v);

    virtual std::string getHeader(const std::string& s);

    virtual void setStatus(int c);

    virtual void reset();

private :

    LaConnection* _parent;
    sl::http::http_response* _response;
    std::vector<servlet::http::Cookie> _cookies;
    boost::shared_ptr<si::interface::Context> _context;
    bool _is_forwarding;
};

} // namespace connector
} // namespace modules

#endif // LA_RESPONSE_H
