/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef LA_REQUEST_H
#define LA_REQUEST_H

#include <istream>
#include <ostream>
#include <string>
#include <vector>
#include <servlet/http/Cookie.h>
#include <sl/inet/http_request.hpp>

#include <si/interface/Request.h>

namespace modules {
namespace connector {

class LaConnection;

class LaRequest : public si::interface::Request {
public :
    LaRequest();

    ~LaRequest();

    void init(LaConnection* parent, sl::http::http_request& req);

    std::string method() const;

    std::string uri() const;

    std::string protocol() const;

    std::string header(const std::string& name) const;

    void cleanup();

    std::ostream& copy_to(std::ostream &);

    std::istream& copy_from(std::istream &);

    virtual std::string getParameter(const std::string& s);

    virtual std::vector<std::string> getParameterNames();

    virtual std::vector<std::string>
    getParameterValues(const std::string& s);

    virtual std::multimap<std::string, std::string> getParameterMap();

    virtual std::string getCharacterEncoding();

    virtual int getContentLength();

    virtual std::string getContentType();

    virtual std::istream& getInputStream();
#if 0
    virtual sl::java::io::BufferedReader getReader();

    virtual const std::locale& getLocale();

    virtual sl::java::util::Enumeration& getLocales();
#endif
    virtual std::string getProtocol();

    virtual std::string getScheme();

    virtual bool isSecure();

    virtual std::string getServerName();

    virtual int getServerPort();

    virtual std::string getLocalAddr();

    virtual std::string getLocalName();

    virtual int getLocalPort();

    virtual std::string getRemoteAddr();

    virtual std::string getRemoteHost();

    virtual int getRemotePort();

    virtual std::string getAuthType();

    virtual std::vector<servlet::http::Cookie> getCookies();

    virtual std::string getHeader(const std::string& s);

    virtual std::vector<std::string> getHeaders(const std::string& s);

    virtual std::vector<std::string> getHeaderNames();

    virtual std::string getMethod();

    virtual std::string getQueryString();

    virtual std::string getRequestURI();

    virtual std::string getRequestURL();

    virtual std::string getContent();

    void content(const std::string& s);

    std::string text();

private :
    LaConnection* _parent;
    sl::http::http_request* _request;
    std::istream* _stream;
    std::stringstream _sstream;
};

} // namespace connector
} // namespace modules

#endif // LA_REQUEST_H
