/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef LA_CONNECTOR_H
#define LA_CONNECTOR_H

#include <string>
#include <vector>
#include <boost/thread.hpp>
#include <boost/shared_ptr.hpp>

#include <sl/class_loader/register.hpp>
#include <sl/inet/connector.hpp>
#include <sl/inet/acceptor.hpp>
#include <sl/inet/ssl_acceptor.hpp>
#include <sl/inet/http_connection.hpp>
#include <sl/inet/ssl_connection.hpp>
#include <sl/inet/derived_type_pool.hpp>

#include <si/interface/Connector.h>
#include "modules/core/DefaultBase.h"
#include "LaHttpConnection.h"
#include "LaSSLConnection.h"

namespace modules {
namespace connector {

class LaConnector
    : public modules::core::DefaultBase, public si::interface::Connector
{
    typedef sl::connector<
        sl::acceptor,
        sl::http_connection,
        sl::derived_type_pool<LaHttpConnection>
    > http_connector_impl_type;

    typedef sl::connector<
        sl::ssl_acceptor,
        sl::ssl_connection,
        sl::derived_type_pool<LaSSLConnection>
    > ssl_connector_impl_type;

public :
    LaConnector();

    ~LaConnector();

    void init();

    void destroy();

    void setPort(int port);

    int getPort();

    void accept();

    void acceptHandler(handler_t);

    void http_access_handle(http_connector_impl_type::connection_type& c);
    void ssl_access_handle(ssl_connector_impl_type::connection_type& c);

private :
    int _port;
    std::string _port_s;

    bool _ssl;
    bool _disable_to;
    bool _lookup;
    int _accept_count;
    int _redirect_port;

    http_connector_impl_type* _http_connector_impl;
    ssl_connector_impl_type* _ssl_connector_impl;
    handler_t _handler;
    std::vector<boost::shared_ptr<boost::thread> > _accept_thread;

    std::string _cert_file;
    std::string _private_file;
};

} // namespace connector
} // namespace modules

SL_REGIST_LOADABLE_CLASS(modules::connector::LaConnector);


#endif // LA_CONNECTOR_H
