/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef LA_CONNECTION_H
#define LA_CONNECTION_H

#include <string>
#include <sl/inet/http_connection.hpp>

#include <si/interface/Connection.h>
#include <si/interface/Request.h>
#include <si/interface/Response.h>

#include "LaRequest.h"
#include "LaResponse.h"

namespace modules {
namespace connector {

class LaConnection : public si::interface::Connection {
public :
    LaConnection();

    virtual ~LaConnection();

    bool operator!();

    si::interface::Request& request();

    si::interface::Response& response();

    bool init();

    virtual bool init(bool lookup)=0;

    virtual sl::http::http_response_writer& writer()=0;

    void close();

    void flush();

    void flushBody();

    void flushHeader();

    bool available() const;

    virtual std::string localHost() const;

    virtual std::string localAddr() const;

    virtual int localPort() const;

    virtual std::string remoteHost() const;

    virtual std::string remoteAddr() const;

    virtual int remotePort() const;

    virtual std::string serverHost() const;

    virtual std::string serverAddr() const;

    virtual int serverPort() const;

    bool remote_info(int sock);
    bool server_info(int /* sock */);
    bool local_info(int sock);

protected :
    LaRequest _request;
    LaResponse _response;
    bool _lookup;

private :
    volatile bool _available;
    volatile bool _reading;
    volatile bool _thread_loop;
    int _accept_socket;
    int _socket;
    int _timeout;
    bool _compress;
    bool _chunked;

    std::string _local_name;
    std::string _local_addr;
    std::string _remote_name;
    std::string _remote_addr;
    std::string _server_name;
    std::string _server_addr;
    int _local_port;
    int _remote_port;
    int _server_port;
};

} // namespace connector
} // namespace modules

#endif // LA_CONNECTION_H
