/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#include <sys/types.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <netinet/in.h>
#include <unistd.h>
#include <boost/lexical_cast.hpp>

#include "LaConnection.h"
using namespace modules::connector;


//
// Constructor/Destructor
//
LaConnection::LaConnection()
{ }


LaConnection::~LaConnection()
{ }



//
// Operators.
//

bool LaConnection::operator!()
{
    return !_available;
}


//
// Member functions.
//

void LaConnection::flushHeader()
{ }

void LaConnection::flushBody()
{ }

void LaConnection::flush()
{ }

bool LaConnection::init()
{ }

void LaConnection::close()
{
}


si::interface::Request& LaConnection::request()
{
    return _request;
}


si::interface::Response& LaConnection::response()
{
    return _response;
}


bool LaConnection::available() const
{ 
    return _available;
}


std::string LaConnection::localHost() const
{
    return _local_name;
}


std::string LaConnection::localAddr() const
{
    return _local_addr;
}


int LaConnection::localPort() const
{
    return _local_port;
}


std::string LaConnection::remoteHost() const
{
    return _remote_name;
}


std::string LaConnection::remoteAddr() const
{
    return _remote_addr;
}


int LaConnection::remotePort() const
{
    return _remote_port;
}


std::string LaConnection::serverHost() const
{
    return _server_name;
}


std::string LaConnection::serverAddr() const
{
    return _server_addr;
}


int LaConnection::serverPort() const
{
    return _server_port;
}


//
// --- private --------------------------------------------------------------
//
#if 1

bool LaConnection::remote_info(int sock)
{
    _remote_port = 0;

    struct sockaddr_in    addr;
    socklen_t            len = sizeof(addr);

    if (getpeername(sock, (struct sockaddr *)&addr, &len) < 0)
        return false;

    _remote_addr = inet_ntoa(addr.sin_addr);
    _remote_port = ntohs(addr.sin_port);

    if (_lookup) {
        struct hostent *host = gethostbyaddr((char *)&addr.sin_addr.s_addr,
                                             sizeof(addr.sin_addr), AF_INET);
        if (!host)
            return false;

        _remote_name = host->h_name;
    } else {
        _remote_name = _remote_addr;
    }

    return true;
}


bool LaConnection::server_info(int /* sock */)
{
    std::string host = _request.header("Host");
    if (!host.empty()) {
        std::string::size_type pos = host.find(':');
        _server_name = host.substr(0, pos);
        if (pos != std::string::npos && pos + 1 != std::string::npos) {
            try {
                _server_port = boost::lexical_cast<int>(host.substr(pos + 1));
            } catch(...) { }
        }
    }
    return true;
}

bool LaConnection::local_info(int sock)
{
    _local_port = 0;

    struct sockaddr_in    addr;
    socklen_t            len = sizeof(addr);

    if (getsockname(sock, (struct sockaddr *)&addr, &len) < 0)
        return false;

    _local_addr = inet_ntoa(addr.sin_addr);
    _local_port = ntohs(addr.sin_port);

    if (_lookup) {
        struct hostent *host = gethostbyaddr((char *)&addr.sin_addr.s_addr,
                                             sizeof(addr.sin_addr), AF_INET);
        if (!host)
            return false;
        _local_name = host->h_name;
    } else
        _local_name = _local_addr;
    return true;
}
#endif
