/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: HttpResponse.h,v 1.11 2008/03/01 03:37:10 cvsuser Exp $
 */

#ifndef __HTTP_RESPONSE_H__
#define __HTTP_RESPONSE_H__

#include <sl/net/http/response.h>

#include "interface/Connection.h"
#include "interface/Context.h"
#include "interface/Response.h"
using namespace si::interface;

// namespace si { namespace modules {

	class HttpResponse : public si::interface::Response {
	public :
		HttpResponse();

		~HttpResponse();

		/**
		 * The member function of the base class is overwrited.
		 * @see		interface::Response::protocol.
		 */
		void protocol(const std::string &protocol);

		/**
		 * The member function of the base class is overwrited.
		 * @see		interface::Response::status.
		 */
		void status(int code, const std::string &msg);

		/**
		 * The member function of the base class is overwrited.
		 * @see		interface::Response::header.
		 */
		void header(const std::string &n, const std::string &v);

		/**
		 * The member function of the base class is overwrited.
		 * @see		interface::Response::content.
		 */
		void content(const std::string &content);

		/**
		 * The member function of the base class is overwrited.
		 * @see		interface::Response::header.
		 */
		void flush();

		/**
		 * The member function of the base class is overwrited.
		 * @see		interface::Response::header.
		 */
		void flushHeader();

		/**
		 * The member function of the base class is overwrited.
		 * @see		interface::Response::header.
		 */
		void flushBody();

		/**
		 * The member function of the base class is overwrited.
		 * @see		interface::Response::header.
		 */
		void cleanup();

		/**
		 * The member function of the base class is overwrited.
		 * @see		interface::Response::header.
		 */
		std::ostream &copy_to(std::ostream &);

		/**
		 * The member function of the base class is overwrited.
		 * @see		interface::Response::header.
		 */
		std::istream &copy_from(std::istream &);

		void parent(Connection *parent);

        void setContext(const boost::shared_ptr<Context>& c);

        boost::shared_ptr<Context> getContext() const;

		std::string text();

		std::string content();

		void erase_header(const std::string &);

		/**
		 * The Content-Type of the response sent back to the client is set.
		 * @param	s	ContentType.
		 */
		virtual void setContentType(const std::string &s);

		/**
		 * The `Content-Length` of the response sent back to the client is set.
		 * @param	i	value of `Content-Length`.
		 */
		virtual void setContentLength(int i);

		/**
		 * The character encoding name applied to the MIME body sent back
		 * by the response is returned.
		 * @return	`CharacterEncoding`
		 */
		virtual std::string getCharacterEncoding();

		/**
		 * The character encoding name applied to the MIME body sent back
		 * by the response is returned.
		 * @return	`ContentType`
		 */
		virtual std::string getContentType();

		/**
		 * 쥹ݥ󥹤Υܥǥ.
		 */
		virtual void setContent(const std::string& s);

	    /**
		 * ꤵ줿Cookie쥹ݥ󥹤ɲäޤ.
		 */
		virtual void addCookie(const servlet::http::Cookie& c);

	    /**
		 *  s ǻꤵ줿ͤĥ쥹ݥ󥹥إåɲäޤ.
		 */
		virtual void addHeader(const std::string& s, const std::string& v);

	    /**
		 *  s ̾ĥإå˥åȤƤ뤫֤ޤ.
		 */
		virtual bool containsHeader(const std::string& s);

	    /**
		 * Хåե򥯥ꥢꤵ줿ơȤäƥ饤Ȥ
		 * 顼쥹ݥ󥹤ޤ.
		 */
		virtual void sendError(int sc);

	    /**
		 * Хåե򥯥ꥢꤵ줿ơȤäƥ饤Ȥ
		 * 顼쥹ݥ󥹤ޤ.
		 */
		virtual void sendError(int sc, const std::string& s);

	    /**
		 * ꤵ줿쥯URLѤơ饤Ȥ
		 * Ūʥ쥯ȥ쥹ݥ󥹤ޤ.
		 */
		virtual void sendRedirect(const std::string& s);

	    /**
		 *  s ǻꤵ줿ͤĥ쥹ݥ󥹥إåꤷޤ.
		 */
		virtual void setHeader(const std::string &s, const std::string &v);

	    /**
		 *  s ǻꤵ줿ͤĥ쥹ݥ󥹥إå֤ޤ.
		 */
		virtual std::string getHeader(const std::string &s);

	    /**
		 * Υ쥹ݥ󥹤Υơɤꤷޤ.
		 */
		virtual void setStatus(int c);

		virtual void reset();

		sl::net::http::response& get();

	private :

		Connection *						_parent;
		boost::shared_ptr<Context>			_context;
		sl::net::http::response				_response;
		std::vector<servlet::http::Cookie>	_cookies;
	};


#endif // __HTTP_RESPONSE_H__
