/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: HttpConnector.h,v 1.24 2008/03/01 03:37:10 cvsuser Exp $
 */

#ifndef __HTTP_CONNECTOR_H__
#define __HTTP_CONNECTOR_H__

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <deque>
#include <set>
#include <vector>
#include <boost/thread.hpp>

#include "interface/config.h"
#include "interface/Connection.h"
#include "interface/Connector.h"
using namespace si;
using namespace si::interface;

#include "modules/core/DefaultBase.h"

// namespace si { namespace modules {

	class HttpConnector
		: public modules::DefaultBase, public interface::Connector
	{
	public :
		HttpConnector();

		~HttpConnector();

		void init();

		void destroy();

		void setPort(int port);

		int getPort();

		void accept();

		void acceptHandler(handler_t);
	
		handler_t acceptHandler();
	
		void setAcceptCount(int count);

		int getAcceptCount() const;

		void setRedirectPort(int port);

		int getRedirectPort() const;

		void setTimeout(int time);

		int getTimeout() const;

		void setDisableUploadTimeout(bool timeout);

		bool getDisableUploadTimeout() const;

		void setExecuteThread(Connection* p);

		void removeExecuteThread(Connection* p);

		void setSpareThread(Connection* p);

		void removeSpareThread(Connection* p);

		sockaddr_in	_addr;
		socklen_t	_addr_length;
	private :

		void wait();

		int			_socket;
		handler_t	_handler;

		volatile bool			_accepted;
		boost::recursive_mutex	_execute_mutex;
		boost::recursive_mutex	_spare_mutex;
		boost::condition		_empty_cond;
		boost::thread*			_wait_thread;

		bool	_disable_to;
		bool	_lookup;
		size_t	_max_thread;
		size_t	_min_spare_thread;
		size_t	_max_spare_thread;
		int		_port;
		int		_accept_count;
		int		_redirect_port;
		int		_timeout;
		int		_current_accept;
		std::deque<Connection *>	_execute_thread;
		std::deque<Connection *>	_spare_thread;

	};

// } } // namespace si::modules

#endif // __HTTP_CONNECTOR_H__
