/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: HttpConnection.h,v 1.30 2008/03/01 03:37:10 cvsuser Exp $
 */

#ifndef __HTTP_CONNECTION_H__
#define __HTTP_CONNECTION_H__

#include <iostream>
#include <string>

#include <sl/net/http/reader.h>
#include <sl/net/http/request.h>
#include <sl/net/http/writer.h>
#include <sl/io/fdstream.h>

#include "interface/Connection.h"
using namespace si::interface;

#include "HttpRequest.h"
#include "HttpResponse.h"

// namespace si { namespace modules {

	class HttpConnector;

	class HttpConnection : public si::interface::Connection {
	public :
		HttpConnection(HttpConnector *parent, int sock);

		virtual ~HttpConnection();

		/**
		 * The member function of the base class is overwrited.
		 * @see		interface::Connection.
		 */
		bool operator!();

		/**
		 * The member function of the base class is overwrited.
		 * @see		interface::Connection.
		 */
		Request &request();

		/**
		 * The member function of the base class is overwrited.
		 * @see		interface::Connection.
		 */
		Response &response();

		/**
		 * The member function of the base class is overwrited.
		 * @see		interface::Connection.
		 */
		bool init();

		/**
		 * The member function of the base class is overwrited.
		 * @see		interface::Connection.
		 */
		void close();

		/**
		 * The member function of the base class is overwrited.
		 * @see		interface::Connection.
		 */
		void flush();

		/**
		 * The member function of the base class is overwrited.
		 * @see		interface::Connection.
		 */
		void flushBody();

		/**
		 * The member function of the base class is overwrited.
		 * @see		interface::Connection.
		 */
		void flushHeader();

		/**
		 * The member function of the base class is overwrited.
		 * @see		interface::Connection.
		 */
		bool available() const;

		/**
		 * The member function of the base class is overwrited.
		 * @see		interface::Connection.
		 */
		virtual std::string targetHost();

		/**
		 * The member function of the base class is overwrited.
		 * @see		interface::Connection.
		 */
		virtual std::string localHost() const;

		/**
		 * The member function of the base class is overwrited.
		 * @see		interface::Connection.
		 */
		virtual std::string localAddr() const;

		/**
		 * The member function of the base class is overwrited.
		 * @see		interface::Connection.
		 */
		virtual int localPort() const;

		/**
		 * The member function of the base class is overwrited.
		 * @see		interface::Connection.
		 */
		virtual std::string remoteHost() const;

		/**
		 * The member function of the base class is overwrited.
		 * @see		interface::Connection.
		 */
		virtual std::string remoteAddr() const;

		/**
		 * The member function of the base class is overwrited.
		 * @see		interface::Connection.
		 */
		virtual int remotePort() const;

		/**
		 * The member function of the base class is overwrited.
		 * @see		interface::Connection.
		 */
		virtual std::string serverHost() const;

		/**
		 * The member function of the base class is overwrited.
		 * @see		interface::Connection.
		 */
		virtual std::string serverAddr() const;

		/**
		 * The member function of the base class is overwrited.
		 * @see		interface::Connection.
		 */
		virtual int serverPort() const;

	private :

		void wait();
		bool server_info(int sock);
		bool remote_info(int sock);
		bool local_info(int sock);
		std::string body_encode(const std::string &content, int type);

		HttpConnector *	_parent;
		HttpRequest 	_request;
		HttpResponse	_response;

		/** io::ifdstream ѤΥݥ.  */
		io::iofdstream			_iostream;

		sl::net::http::reader	_reader;
		sl::net::http::writer	_writer;
		sl::net::http::request	_real_msg;

		volatile bool	_available;
		volatile bool	_reading;
		volatile bool	_thread_loop;
		int				_accept_socket;
		int				_socket;
		int				_timeout;
		bool			_compress;
		bool			_chunked;

		bool			_lookup;
		std::string		_local_name;
		std::string		_local_addr;
		int				_local_port;
		std::string		_remote_name;
		std::string		_remote_addr;
		int				_remote_port;
		std::string		_server_name;
		std::string		_server_addr;
		int				_server_port;

		boost::thread*	_wait_thread;
	};

// } } // namespace si::modules

#endif //
