/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: Ajp13Response.h,v 1.11 2008/05/06 16:26:11 cvsuser Exp $
 */

#ifndef __AJP13_RESPONSE_H__
#define __AJP13_RESPONSE_H__


#include <sl/net/ajp13/end_response_packet.h>
#include <sl/net/ajp13/send_body_chunk_packet.h>
#include <sl/net/ajp13/send_headers_packet.h>

#include <si/interface/Connection.h>
#include <si/interface/Context.h>
#include <si/interface/Response.h>
using namespace si::interface;

namespace modules { namespace connector {

	class Ajp13Connection;

	class Ajp13Response : public si::interface::Response {
	public :
		Ajp13Response();

		~Ajp13Response();

		void protocol(const std::string &protocol);

		void status(int code, const std::string &msg);

		void header(const std::string &n, const std::string &v);

		void content(const std::string &content);

		void flush();

		void flushHeader();

		void flushBody();

		void cleanup();

		std::ostream &copy_to(std::ostream &);

		std::istream &copy_from(std::istream &);

		void parent(Connection *parent);

		void setContext(const boost::shared_ptr<Context>& c);

		boost::shared_ptr<Context> getContext() const;

		void write(int fd);

		virtual void setContentType(const std::string &s);

		virtual void setContentLength(int i);

		virtual std::string getCharacterEncoding();

		virtual std::string getContentType();

		virtual void setContent(const std::string& s);

		virtual void addCookie(const servlet::http::Cookie& c);

		virtual void addHeader(const std::string& s, const std::string& v);

		virtual bool containsHeader(const std::string& s);

		virtual void eraseHeader(const std::string& s);

		virtual std::string getHeader(const std::string &s);

		virtual void sendError(int sc);

		virtual void sendError(int sc, const std::string& s);

		virtual void sendRedirect(const std::string& s);

		virtual void setHeader(const std::string &s, const std::string &v);

		virtual void setStatus(int c);

		virtual void reset();

	private :
		boost::shared_ptr<Context>	_context;
		Connection *	_parent;
		int				_socket;

		sl::net::ajp13::send_headers_packet		_headers;
		sl::net::ajp13::send_body_chunk_packet	_body_chunk;
		sl::net::ajp13::end_response_packet		_end;
		std::vector<servlet::http::Cookie>		_cookies;

		friend class Ajp13Connection;
	};

} } // namespace modules::connector

#endif // __AJP13_RESPONSE_H__
