/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: Ajp13Response.cpp,v 1.33 2008/05/06 16:26:11 cvsuser Exp $
 */

#include <iostream>
#include <sstream>
#include <string>
#include <vector>
#include <boost/lexical_cast.hpp>
using namespace std;
using namespace boost;

#include <sl/net/ajp13/function.h>
#include <sl/net/http/http_types.h>

#include <servlet/ServletContext.h>
#include <servlet/RequestDispatcher.h>
using namespace servlet;

#include <si/core/ErrorPage.h>
#include <si/core/HttpServletRequestImpl.h>
#include <si/core/HttpServletResponseImpl.h>

#include "Ajp13Response.h"
using namespace modules::connector;

#define _4KB	(4096 * 1)

//
// Interface/Destructor.
//

Ajp13Response::Ajp13Response()
{ }


Ajp13Response::~Ajp13Response()
{ }


//
// Member functions.
//


void Ajp13Response::protocol(const string &)
{
}


void Ajp13Response::status(int code, const string &msg)
{
	_headers.status_code(code);
	_headers.status_msg(msg);
}


void Ajp13Response::header(const string &n, const string &v)
{
	std::cerr << "header:" << n << " " << v << std::endl;
	_headers.header(n, v);
}

void Ajp13Response::flushHeader()
{
#ifdef DEBUG
    std::cerr << "Ajp13Response::flushHeader" << std::endl;
#endif
	// 쥹ݥ󥹥ɤ̤ξ 200 OK ꤷƤ.
	if (_headers.status_code() == 0)
		_headers.status_code(200);

	if (_headers.status_msg().empty())
		_headers.status_msg(sl::net::http::status_code::to_string(_headers.status_code()));

	// Content-Type إåʤ WEB ¦ʤ
	if (!_headers.is_exist("Content-Type"))
		_headers.header("Content-Type", "text/html");

    // å򥳥ԡ
    vector<servlet::http::Cookie>::iterator i = _cookies.begin();
    for (; i != _cookies.end(); i++) {
		string path = !i->getPath().empty() ? "; Path=" + i->getPath() : "";
		_headers.header("Set-Cookie", i->getName() +"="+ i->getValue() + path);
	}
std::cerr << "size:" << _headers.size() << std::endl;
	sl::net::ajp13::write_packet(_socket, _headers);
}

void Ajp13Response::flushBody()
{
#ifdef DEBUG
    std::cerr << "Ajp13Response::flushBody" << std::endl;
#endif
	if (_body_chunk.size() >= _4KB) {
		std::string body = _body_chunk.body_chunk();

		for (;;) {
			sl::net::ajp13::send_body_chunk_packet chunk;
			chunk.body_chunk(body.substr(0, _4KB));

			sl::net::ajp13::write_packet(_socket, chunk);

			if (body.length() >= _4KB)
				body.erase(0, _4KB);
			else
				break;
		}
	} else
		sl::net::ajp13::write_packet(_socket, _body_chunk);

	_body_chunk.clear();
}

void Ajp13Response::flush()
{
#ifdef DEBUG
    std::cerr << "Ajp13Response::flush" << std::endl;
#endif
	_end.reuse(true);
	sl::net::ajp13::write_packet(_socket, _end);

	_parent->flush();
}


void Ajp13Response::content(const string &content)
{
	_body_chunk.body_chunk(content);
}


void Ajp13Response::cleanup()
{
	_headers.clear();
	_body_chunk.clear();
	_end.clear();
}


ostream &Ajp13Response::copy_to(ostream &os)
{
#ifdef DEBUG
	cerr << "Ajp13Response::" << __FUNCTION__ << endl;
#endif

	using namespace sl::net::ajp13;

	try {
		write_packet(os, _headers);
		write_packet(os, _body_chunk);
		write_packet(os, _end);

	} catch(ajp13_error &e) {
		cerr << e.what() << endl;
		cerr << "It faild in function " << __FUNCTION__ << endl;
	}

	return os;
}


istream &Ajp13Response::copy_from(istream &is)
{
#ifdef DEBUG
	cerr << "Ajp13Response::" << __FUNCTION__ << endl;
#endif

	using namespace sl::net::ajp13;

	try {
		read_packet(is, _headers);
		read_packet(is, _body_chunk);
		read_packet(is, _end);

	} catch(ajp13_error &e) {
		cerr << e.what() << endl;
		cerr << "It faild in function " << __FUNCTION__ << endl;
	}

	return is;
}


void Ajp13Response::parent(Connection *parent)
{
	_parent = parent;
}


void Ajp13Response::write(int fd)
{
#ifdef DEBUG
	cerr << "Ajp13Response::" << __FUNCTION__ << endl;
#endif
	_socket = fd;
}

void Ajp13Response::setContext(const boost::shared_ptr<Context>& c)
{
	_context = c;
}

boost::shared_ptr<Context> Ajp13Response::getContext() const
{
	return _context;
}


void Ajp13Response::setContentType(const std::string &s)
{
	_headers.header("Content-Type", s);
}

void Ajp13Response::setContentLength(int i)
{
	std::string length;
	try {
		length = lexical_cast<std::string>(i);
	} catch (...) { }

	_headers.header("Content-Length", length);
}

std::string Ajp13Response::getCharacterEncoding()
{
	return "";
}

std::string Ajp13Response::getContentType()
{
	return "";
}

void Ajp13Response::setContent(const std::string& s)
{ 
	_body_chunk.body_chunk(s);
}

void Ajp13Response::addCookie(const servlet::http::Cookie& c)
{
	_cookies.push_back(c);
}

void Ajp13Response::addHeader(const std::string& s, const std::string& v)
{
	_headers.header(s, v);
}

bool Ajp13Response::containsHeader(const std::string& s)
{
	return false;
}

std::string Ajp13Response::getHeader(const std::string &s)
{
	return "";
}

void Ajp13Response::sendError(int c)
{
	sendError(c, "");
}

void Ajp13Response::sendError(int c, const std::string& s)
{
	setStatus(c);
	eraseHeader("Content-Length");

	bool success = false;
	if (_context) {
		std::string path = _context->getErrorPage(c);
		if (!path.empty()) {
			si::core::HttpServletRequestImpl  req(*_parent, *_context);
			si::core::HttpServletResponseImpl res(*_parent, *_context);

			ServletContext& sc = _context->getServletContext();
			std::auto_ptr<servlet::RequestDispatcher> r =
												sc.getRequestDispatcher(path);
			if (*r) {
				r->forward(req, res);
				success = true;
				res.flushBuffer();
			}
		}
	}

    if (!success) {
        setContentType("text/html;charset=iso-8859-1");
        std::string error = ErrorPage().create(c, "", "", s);
        setContent(error);

        addHeader("Content-Length",
                  boost::lexical_cast<std::string>(error.length()));
        flushHeader();
        flushBody();
    }
    flush();
}

void Ajp13Response::sendRedirect(const std::string& s)
{
	setStatus(307);
	addHeader("Location", s);
}

void Ajp13Response::setHeader(const std::string& s, const std::string& v)
{
	_headers.header(s, v);
}

void Ajp13Response::eraseHeader(const std::string& s)
{
	_headers.erase_header(s);
}

void Ajp13Response::setStatus(int code)
{
	_headers.status_code(code);
}

void Ajp13Response::reset()
{
	sl::net::ajp13::send_headers_packet temp = _headers;
	_headers.clear();
	_headers.status_code(temp.status_code());
	_headers.status_msg(temp.status_msg());
}
