/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: Ajp13Request.h,v 1.11 2008/05/06 16:26:11 cvsuser Exp $
 */

#ifndef __AJP13_REQUEST_H__
#define __AJP13_REQUEST_H__

#include <sstream>

#include <sl/net/ajp13/forward_request_packet.h>
#include <sl/net/ajp13/request_body_chunk_packet.h>

#include <si/interface/Connection.h>
#include <si/interface/Request.h>
using namespace si::interface;


namespace modules { namespace connector {

	class Ajp13Connection;

	class Ajp13Request : public si::interface::Request {
	public :
		Ajp13Request();

		virtual ~Ajp13Request();

		/**
		 * The member function of the base class is overwrited.
		 * @see		interface::Request::method().
		 */
		std::string method() const;

		/**
		 * The member function of the base class is overwrited.
		 * @see		interface::Request::uri().
		 */
		std::string uri() const;

		/**
		 * The member function of the base class is overwrited.
		 * @see		interface::Request::uri().
		 */
		std::string protocol() const;

		/**
		 * The member function of the base class is overwrited.
		 * @see		interface::Request::uri().
		 */
		std::string header(const std::string &name) const;

		/**
		 * The member function of the base class is overwrited.
		 * @see		interface::Request::copy_to().
		 */
		std::ostream &copy_to(std::ostream &);

		/**
		 * The member function of the base class is overwrited.
		 * @see		interface::Request::copy_from().
		 */
		std::istream &copy_from(std::istream &);

		/**
		 * The member function of the base class is overwrited.
		 * @see		interface::Request::cleanup().
		 */
		void cleanup();

		void parent(Connection *parent);

		void read(int fd);

		/**
		 * The value of parameter with the same name as argument `name`
		 * is returned.
		 * @param	name	name of parameter.
		 * @return		value of parameter.
		 */
		virtual std::string getParameter(const std::string &s);

		/**
		 * List of parameter name is returned.
		 * @return	list of parameter name.
		 */
		virtual std::vector<std::string> getParameterNames();

		/**
		 * List of parameter value is returned.
		 * @return	list of parameter value.
		 */
		virtual std::vector<std::string>
		getParameterValues(const std::string& s);

		/**
		 * Map of parameter value is returned.
		 * @return	list of parameter value.
		 */
		virtual std::multimap<std::string, std::string> getParameterMap();

		/**
		 * The encode set to the request is returned. 
		 * @return	encode.
		 */
		virtual std::string getCharacterEncoding();

		/**
		 * `ContentLength` set to the request is returned.
		 * @return	size.
		 */
		virtual int getContentLength();

		/**
		 * `ContentType` set to the request is returned.
		 * @return	ContentType.
		 */
		virtual std::string getContentType();

		/**
		 * The istream object to operate the request as a stream is returned.
		 * @return	Instance of ServletInputStream class.
		 */
		virtual std::istream& getInputStream();
#if 0
		/**
		 * The istream object to operate the request as a stream is returned.
		 * @return	Instance of Reader class.
		 */
		virtual java::io::BufferedReader getReader();

		/**
		 * Locale assumed for the client to be able to display contents
		 * is returned. 
		 * @return	std::locale.
		 */
		virtual const std::locale &getLocale();

		/**
		 * Locale assumed for the client to be able to display contents
		 * is returned. 
		 * @return	list of locale.
		 */
		virtual java::util::Enumeration &getLocales();
#endif
		/**
		 * The protocol name and the version of the request are returned. 
		 * @return	protocol/version.
		 */
		virtual std::string getProtocol();

		/**
		 * Schemes such as http and ftp etc. are returned. 
		 * @return	scheme.
		 */
		virtual std::string getScheme();

		/**
		 * The presence of the encryption of the communication route
		 * of the SSL communication etc. is returned. 
		 * @return	bool.
		 */
		virtual bool isSecure();

		/**
		 * The server name is acquired. 
		 * @return	server name.
		 */
		virtual std::string getServerName();

		/**
		 * The port number used by the server is acquired. 
		 * @return	port number.
		 */
		virtual int getServerPort();

		/**
		 * @return	IP address.
		 */
		virtual std::string getLocalAddr();

		/**
		 * @return	host name.
		 */
		virtual std::string getLocalName();

		/**
		 * @return	port number.
		 */
		virtual int getLocalPort();

		/**
		 * IP address in the transmission origin of the request is returned. 
		 * @return	IP address.
		 */
		virtual std::string getRemoteAddr();

		/**
		 * The host name of the transmission origin of the request is returned. 
		 * @return	host name.
		 */
		virtual std::string getRemoteHost();

		/**
		 * @return	port number.
		 */
		virtual int getRemotePort();

		/**
		 * ǧڥ֤̾ޤ.
		 * @return	String ̾.
		 */
		virtual std::string getAuthType();

		/**
		 * åΥꥹȤ.
		 * @return	åΥꥹ.
		 */
		virtual std::vector<servlet::http::Cookie> getCookies();

		/**
		 *  s бإå֤ͤޤ.
		 * @param	s	إå̾.
		 * @return	إå.
		 */
		virtual std::string getHeader(const std::string &s);

		/**
		 *  s бإå֤ͤޤ.
		 * @param	s	إå̾.
		 * @return	إå.
		 */
		virtual std::vector<std::string> getHeaders(const std::string &s);

		/**
		 * إå̾ΥꥹȤ֤ޤ.
		 * @return	إå̾Υꥹ.
		 */
		virtual std::vector<std::string> getHeaderNames();

		/**
		 * ꥯȤΥ᥽åɤ֤ޤ.
		 * @return	᥽å.
		 */
		virtual std::string getMethod();

		/**
		 * ꥯȤΥ꡼ޤ.
		 * @return	꡼.
		 */
		virtual std::string getQueryString();

		/**
		 * ꥯȤURIޤ.
		 * @return	URI.
		 */
		virtual std::string getRequestURI();

		/**
		 * ꥯȤURLޤ.
		 * @return	URL.
		 */
		virtual std::string getRequestURL();

		/**
		 * ꥯΥƥĤ֤ޤ.
		 * @return	ƥĥǡ.
		 */
		virtual std::string getContent();

	private :

		Connection *	_parent;
		sl::net::ajp13::forward_request_packet	 	_headers;
		sl::net::ajp13::request_body_chunk_packet	_body_chunk;

		std::istream*		_stream;
		std::stringstream	_sstream;

		friend class Ajp13Connection;
	};

} } // namespace modules::connector

#endif // __AJP13_REQUEST_H__
