/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: Ajp13Connector.h,v 1.16 2008/05/06 16:26:11 cvsuser Exp $
 */

#ifndef __AJP13_CONNECTOR_H__
#define __AJP13_CONNECTOR_H__

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <deque>
#include <set>
#include <vector>
#include <boost/thread.hpp>
#include <boost/thread/condition.hpp>

#include <si/interface/Config.h>
#include <si/interface/Connection.h>
#include <si/interface/Connector.h>
using namespace si::interface;

#include "modules/core/DefaultBase.h"

namespace modules { namespace connector {

	class Ajp13Connector : virtual public Connector, virtual public modules::core::DefaultBase 
	{
		typedef std::vector<boost::thread *>	thread_list_t;
		typedef std::vector<int>				socket_queue_t;
	public :
		Ajp13Connector();

		~Ajp13Connector();

		/**
		 * The member function of the base class is overwrited.
		 * @see		interface::Base.
		 */
		void init();

		/**
		 * The member function of the base class is overwrited.
		 * @see		interface::Base.
		 */
		void destroy();

		/**
		 * The member function of the base class is overwrited.
		 * @see		interface::Connector.
		 */
		void setPort(int port);

		/**
		 * The member function of the base class is overwrited.
		 * @see		interface::Connector.
		 */
		int getPort();

		/**
		 * The member function of the base class is overwrited.
		 * @see		interface::Connector.
		 */
		void accept();

		/**
		 * The member function of the base class is overwrited.
		 * @see		interface::Connector.
		 */
		void acceptHandler(boost::function<void (Connection&)>);

	private :

		void proc(Connection*);
		void queue();

		struct sockaddr_in	_addr;
		socklen_t			_addr_length;
		int		_socket;
		int		_port;
		int		_max_thread;


		volatile bool			_accepted;
		boost::recursive_mutex	_mutex;
		boost::condition		_empty_cond;

		boost::function<void (Connection&)> _handler;
		thread_list_t	_proc_threads;
		thread_list_t	_queue_threads;
		socket_queue_t	_socket_queue;
	};

} } // namespace modules::connector


#endif // __AJP13_CONNECTOR_H__
