/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: Ajp13Connection.h,v 1.13 2008/05/06 16:26:11 cvsuser Exp $
 */

#ifndef __AJP13_CONNECTION_H__
#define __AJP13_CONNECTION_H__

#include <iostream>

#include <si/interface/Connection.h>
#include "Ajp13Request.h"
#include "Ajp13Response.h"


namespace modules { namespace connector {

	class Ajp13Connector;

	class Ajp13Connection : public si::interface::Connection {
	public :
		Ajp13Connection(Ajp13Connector *parent, int sock);

		virtual ~Ajp13Connection();

		/**
		 * The member function of the base class is overwrited.
		 * @see		interface::Connection.
		 */
		bool operator!();

		/**
		 * The member function of the base class is overwrited.
		 * @see		interface::Connection.
		 */
		Request &request();

		/**
		 * The member function of the base class is overwrited.
		 * @see		interface::Connection.
		 */
		Response &response();

		/**
		 * The member function of the base class is overwrited.
		 * @see		interface::Connection.
		 */
		bool init();

		/**
		 * The member function of the base class is overwrited.
		 * @see		interface::Connection.
		 */
		void close();

		/**
		 * The member function of the base class is overwrited.
		 * @see		interface::Connection.
		 */
		void flush();

		/**
		 * The member function of the base class is overwrited.
		 * @see		interface::Connection.
		 */
		void flushBody();

		/**
		 * The member function of the base class is overwrited.
		 * @see		interface::Connection.
		 */
		void flushHeader();

		/**
		 * The member function of the base class is overwrited.
		 * @see		interface::Connection.
		 */
		bool available() const;

		/**
		 * The member function of the base class is overwrited.
		 * @see		interface::Connection.
		 */
		virtual std::string targetHost();

		/**
		 * The member function of the base class is overwrited.
		 * @see		interface::Connection.
		 */
		virtual std::string localHost() const;

		/**
		 * The member function of the base class is overwrited.
		 * @see		interface::Connection.
		 */
		virtual std::string localAddr() const;

		/**
		 * The member function of the base class is overwrited.
		 * @see		interface::Connection.
		 */
		virtual int localPort() const;

		/**
		 * The member function of the base class is overwrited.
		 * @see		interface::Connection.
		 */
		virtual std::string remoteHost() const;

		/**
		 * The member function of the base class is overwrited.
		 * @see		interface::Connection.
		 */
		virtual std::string remoteAddr() const;

		/**
		 * The member function of the base class is overwrited.
		 * @see		interface::Connection.
		 */
		virtual int remotePort() const;

		/**
		 * The member function of the base class is overwrited.
		 * @see		interface::Connection.
		 */
		virtual std::string serverHost() const;

		/**
		 * The member function of the base class is overwrited.
		 * @see		interface::Connection.
		 */
		virtual std::string serverAddr() const;

		/**
		 * The member function of the base class is overwrited.
		 * @see		interface::Connection.
		 */
		virtual int serverPort() const;

        std::string scheme() const;

	private :

		void local_info(int sock);

		bool			_available;
		bool			_reading;
		int				_socket;
		Ajp13Connector* _parent;
		Ajp13Request	_request;
		Ajp13Response	_response;

		bool			_lookup;
		boost::mutex	_mutex;
	};

} } // namespace modules::connector

#endif // __AJP13_CONNECTION_H__
