/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: Ajp13Connection.cpp,v 1.17 2006/10/29 03:18:49 cvsuser Exp $
 */

#include <sys/types.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <netinet/in.h>
#include <unistd.h>

#include <string>
#include <boost/algorithm/string/predicate.hpp>
using namespace std;
using namespace boost;

#include <sl/net/ajp13/packet_set.h>

#include "Ajp13Connector.h"
#include "Ajp13Connection.h"
#include "Ajp13Request.h"
#include "Ajp13Response.h"
using namespace modules::connector;

//
// Constructor/Destructor
//

Ajp13Connection::Ajp13Connection(Ajp13Connector *parent, int sock)
	: _available(true)
{
	_parent = parent;
	_socket = sock;

	_request.parent(this);
	_response.parent(this);
}


Ajp13Connection::~Ajp13Connection()
{
	this->close();
}


//
// Operators.
//


bool Ajp13Connection::operator!()
{
	return !_available;
}


//
// Member functions.
//

bool Ajp13Connection::init()
{
	try {
		_request.read(_socket);
		_response.write(_socket);
	} catch(std::runtime_error& e) { throw e; }
}

void Ajp13Connection::flushHeader()
{ }

void Ajp13Connection::flushBody()
{ }

void Ajp13Connection::flush()
{
#ifdef DEBUG
	cerr << "Ajp13Connection::flush Enter" << endl;
#endif
	_request.cleanup();
	_response.cleanup();
}


string Ajp13Connection::targetHost()
{
	return _request.header("Host");
}


Request &Ajp13Connection::request()
{
	return _request;
}


Response &Ajp13Connection::response()
{
	return _response;
}


bool Ajp13Connection::available() const
{
	return _available;
}


void Ajp13Connection::close()
{
	if (_available) {
		_available = false;

		::shutdown(_socket, SHUT_RDWR);
		::close(_socket);
	}
}


string Ajp13Connection::localHost() const
{ return ""; }

string Ajp13Connection::localAddr() const
{ return ""; }

int Ajp13Connection::localPort() const
{ return 0; }

string Ajp13Connection::remoteHost() const
{ return ""; }

string Ajp13Connection::remoteAddr() const
{ return ""; }

int Ajp13Connection::remotePort() const
{ return 0; }

string Ajp13Connection::serverHost() const
{ return ""; }

string Ajp13Connection::serverAddr() const
{ return ""; }

int Ajp13Connection::serverPort() const
{ return 0; }

void Ajp13Connection::local_info(int)
{ }

std::string Ajp13Connection::scheme() const
{ return ""; }
