#*-
# Copyright (c) 2008 Masashi Osakabe
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
# ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
# OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
# LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
# OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
# SUCH DAMAGE.
#
# $Id: ax_si.m4,v 1.5 2008/03/03 16:30:06 cvsuser Exp $
#
#
# --with-si={directory}
# --with-si-instdir={directory}
#
# AX_SI
#
# configure.in
#   :AC_SUBST(SI_CPPFLAGS)
#   :AC_SUBST(SI_LDFLAGS)
#   :AC_SUBST(SI_LIB)
#   :AC_SUBST(SI_INSTDIR)
#   :AC_SUBST(SI_VERSION)
#
# config.h.in
#   :HAVE_SI
#

AC_DEFUN([AX_SI],
[
    AC_ARG_WITH([si],
                AS_HELP_STRING([--with-si=DIR],
                [use  (default is yes) specify the root directory for shibainu servlet container library(optional)]),
                [
                if test "$withval" = "no"; then
                    want_si="no"
                elif test "$withval" = "yes"; then
                    want_si="yes"
                    ax_si_path=""
                else
                    want_si="yes"
                    ax_si_path="$withval"
                fi
                ],
                [want_si="yes"])

    if test "x$want_si" = "xyes"; then
        AC_REQUIRE([AC_PROG_CC])
        AC_MSG_CHECKING(for shibainu)

        if test "$ax_si_path" != ""; then
            SI_LDFLAGS="-L$ax_si_path/lib"
            SI_CPPFLAGS="-I$ax_si_path/include"
        else
            for ax_si_path_tmp in /usr /usr/local /usr/pkg /opt ; do
                if test -d "$ax_si_path_tmp/include/si" && test -r "$ax_si_path_tmp/include/si"; then
                    SI_LDFLAGS="-L$ax_si_path_tmp/lib"
                    SI_CPPFLAGS="-I$ax_si_path_tmp/include"
                    break;
                fi
            done
        fi

        CPPFLAGS="$CPPFLAGS $SI_CPPFLAGS"
        export CPPFLAGS

        LDFLAGS="$LDFLAGS $SI_LDFLAGS"
        export LDFLAGS

        if test "$SI_CPPFLAGS" = "";then
            AC_MSG_RESULT(no)
            AC_MSG_ERROR('*** shibainu servlet container is not exist')
        fi
        AC_MSG_RESULT(yes)

        AC_SUBST(SI_CPPFLAGS)
        AC_SUBST(SI_LDFLAGS)

		ax_lib=si_core
		AC_CHECK_LIB($ax_lib, exit, [SI_LIB="-l$ax_lib";
			AC_SUBST(SI_LIB) link_si="yes";break], [link_si="no"])
		if test "x$link_si" = "xno"; then
			AC_MSG_WARN(Could not link against lib$ax_lib !)
		else
			AC_DEFINE(HAVE_SI, ,
				[Define to 1 if the libsi_core is available])
		fi
    fi
])



AC_DEFUN([AX_SI_INSTDIR],
[
    AC_ARG_WITH([si-instdir],
                AS_HELP_STRING([--with-si-instdir=DIR],
                [use  (default is yes) specify the root directory for shibainu servlet container library(optional)]),
                [
                if test "$withval" = "no"; then
                    want_si="no"
                elif test "$withval" = "yes"; then
                    want_si="yes"
                    ax_si_dir_path=""
                else
                    want_si="yes"
                    ax_si_dir_path="$withval"
                fi
                ],
                [want_si="yes"])

    if test "x$want_si" = "xyes"; then
        AC_REQUIRE([AC_PROG_CC])
        AC_MSG_CHECKING(for shibainu install directory)

        if test "$ax_si_dir_path" != ""; then
            SI_INSTDIR="$ax_si_dir_path"
        else
            for ax_si_dir_path_tmp in /usr /usr/local /usr/pkg /opt "$ax_si_path" ; do
				if ! test -d "$ax_si_dir_path_tmp" ; then
					continue;
				fi
				for ax_si_dir in `ls $ax_si_dir_path_tmp | grep '^shibainu-'` ; do
                	if test -d "$ax_si_dir_path_tmp"/"$ax_si_dir" ; then
                    	SI_INSTDIR="$ax_si_dir_path_tmp"/"$ax_si_dir"
                    	#break;
                	fi
				done
            done
        fi

        if test "$SI_INSTDIR" = "" ; then
            AC_MSG_RESULT(no)
            AC_MSG_ERROR('*** shibainu install directory is not found')
        fi
        AC_MSG_RESULT($SI_INSTDIR)
        AC_SUBST(SI_INSTDIR)
    fi
])
