#*-
# Copyright (c) 2008 Masashi Osakabe
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
# ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
# OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
# LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
# OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
# SUCH DAMAGE.
#
# $Id: ax_sa.m4,v 1.5 2008/03/01 17:04:57 cvsuser Exp $
#
#
# --with-servlet={directory}
#
# AX_SERVLET([MINIMUM-VERSION], [ACTION-IF-FOUND], [ACTION-IF-NOT-FOUND])
#
# configure.in
#   :AC_SUBST(SERVLET_CPPFLAGS)
#   :AC_SUBST(SERVLET_LDFLAGS)
#   :AC_SUBST(SERVLET_API_LIB)
#   :AC_SUBST(SERVLET_JSP_LIB)
#
# config.h.in
#   :HAVE_SERVLET
#

AC_DEFUN([AX_SERVLET],
[
	AC_ARG_WITH([servlet],
				AS_HELP_STRING([--with-servlet=DIR],
				[use cpp-servletr-api (default is yes) specify the root directory for c++ servlet api (optional)]),
				[
				if test "$withval" = "no"; then
					want_servlet="no"
				elif test "$withval" = "yes"; then
					want_servlet="yes"
					ax_servlet_path=""
				else
					want_servlet="yes"
					ax_servlet_path="$withval"
				fi
				],
				[want_servlet="yes"])

	if test "x$want_servlet" = "xyes"; then
		AC_REQUIRE([AC_PROG_CC])
		AC_MSG_CHECKING(for c++ servlet api)

		if test "$ax_servlet_path" != ""; then
			SERVLET_LDFLAGS="-L$ax_servlet_path/lib"
			SERVLET_CPPFLAGS="-I$ax_servlet_path/include"
		else
			for ax_servlet_path_tmp in /usr /usr/local /usr/pkg /opt ; do
				if test -d "$ax_servlet_path_tmp/include/servlet" && test -r "$ax_servlet_path_tmp/include/servlet/Servlet.h"; then
					SERVLET_LDFLAGS="-L$ax_servlet_path_tmp/lib"
					SERVLET_CPPFLAGS="-I$ax_servlet_path_tmp/include"
					break;
				fi
			done
		fi

		if test "$SERVLET_CPPFLAGS" = "";then
			AC_MSG_RESULT(no)
			AC_MSG_WARN('c++ servlet api is not exist')
		else
			AC_MSG_RESULT(yes)
			AC_SUBST(SERVLET_CPPFLAGS)
			AC_SUBST(SERVLET_LDFLAGS)
		fi

		ax_lib=si_servletapi
		AC_CHECK_LIB($ax_lib, exit, [SERVLET_API_LIB="-l$ax_lib";
			AC_SUBST(SERVLET_API_LIB) link_sa="yes";break], [link_sa="no"])
		if test "x$link_sa" = "xno"; then
			AC_MSG_WARN(Could not link against lib$ax_lib !)
		else
			AC_DEFINE(HAVE_SERVLER, ,
				[Define to 1 if the libsi_servletapi is available])
		fi
		ax_lib=si_jspapi
		AC_CHECK_LIB($ax_lib, exit, [SERVLET_JSP_LIB="-l$ax_lib";
			AC_SUBST(SERVLET_JSP_LIB) link_sa="yes";break], [link_sa="no"])
		if test "x$link_sa" = "xno"; then
			AC_MSG_WARN(Could not link against lib$ax_lib !)
		else
			AC_DEFINE(HAVE_SERVLER, ,
				[Define to 1 if the libsi_jspapi is available])
		fi
	fi
])
