#*-
# Copyright (c) 2008 Masashi Osakabe
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
# ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
# OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
# LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
# OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
# SUCH DAMAGE.
#
# $Id: ax_execinfo.m4,v 1.1 2008/02/09 21:04:33 cvsuser Exp $
#
#
# --with-execinfo={directory}
#
# AX_EXECINFO
#
# configure.in
#   :AC_SUBST(EXECINFO_CPPFLAGS)
#   :AC_SUBST(EXECINFO_LDFLAGS)
#   :AC_SUBST(EXECINFO_LIB)
#
# config.h.in
#   :HAVE_EXECINFO
#

AC_DEFUN([AX_EXECINFO],
[
	AC_ARG_WITH([execinfo],
				AS_HELP_STRING([--with-execinfo=DIR],
				[use execinfo (default is yes) specify the root directory for execinfo library (optional)]),
				[
				if test "$withval" = "no"; then
					want_execinfo="no"
				elif test "$withval" = "yes"; then
					want_execinfo="yes"
					ac_execinfo_path=""
				else
					want_execinfo="yes"
					ac_execinfo_path="$withval"
				fi
				],
				[want_execinfo="yes"])

	if test "x$want_execinfo" = "xyes"; then
		AC_REQUIRE([AC_PROG_CC])
		AC_MSG_CHECKING(for execinfo.h)

		if test "$ac_execinfo_path" != ""; then
			EXECINFO_CPPFLAGS="-I$ac_execinfo_path/include"
			EXECINFO_LDFLAGS="-L$ac_execinfo_path/lib"
		else
			for ac_execinfo_path_tmp in /usr /usr/local /opt ; do
				if test -d "$ac_execinfo_path_tmp" && test -r "$ac_execinfo_path_tmp/include/execinfo.h"; then
					EXECINFO_CPPFLAGS="-I$ac_execinfo_path_tmp/include"
					EXECINFO_LDFLAGS="-L$ac_execinfo_path_tmp/lib"
					break;
				fi
			done
		fi

		if test "$EXECINFO_CPPFLAGS" = "";then
			AC_MSG_RESULT(no)
			AC_MSG_WARN('*** execinfo.h does not exist')
		else
			AC_MSG_RESULT(yes)

			CPPFLAGS="$CPPFLAGS $EXECINFO_CPPFLAGS"
			export CPPFLAGS
			LDFLAGS="$LDFLAGS $EXECINFO_LDFLAGS"
			export LDFLAGS

			AC_SUBST(EXECINFO_CPPFLAGS)
			AC_SUBST(EXECINFO_LDFLAGS)

			ax_lib=execinfo
			AC_CHECK_LIB($ax_lib, backtrace, [EXECINFO_LIB="-l$ax_lib";
				AC_SUBST(EXECINFO_LIB) link_execinfo="yes";break], [link_execinfo="no"])
			if test "x$link_execinfo" = "xno"; then
				AC_MSG_WARN(Could not link against lib$ax_lib !)
			else
				AC_DEFINE(HAVE_EXECINFO, ,
					[Define to 1 if the libexecinfo is available])
			fi
		fi
	fi
])
