#*-
# Copyright (c) 2008 Masashi Osakabe
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
# ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
# OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
# LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
# OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
# SUCH DAMAGE.
#
# $Id: ax_cxxflags.m4,v 1.7 2008/03/11 17:52:23 cvsuser Exp $
#
#
# AX_CXXFLAGS()
#
# configure.in
#
# config.h.in
#

AC_DEFUN([AX_CXXFLAGS],
[
    #
    # It searches for the thread library that is appropriate for the system. 
    #
    AC_MSG_CHECKING(it searches for the thread library)
	case "x$build_os" in
	xsolaris )
		CXXFLAGS="-pthreads $CXXFLAGS"
		ax_thread_search_result="-pthreads is included in CXXFLAGS."
		;;
	*linux* )
		CXXFLAGS="-pthread $CXXFLAGS"
		ax_thread_search_result="-pthread is included in CXXFLAGS."
		;;
	xmingw* )			
		CXXFLAGS="-mthreads $CXXFLAGS"
		ax_thread_search_result="-mthreads is included in CXXFLAGS."
		;;
	xfreebsd6* )
		LIBS="/usr/lib/libc_r.so $LIBS"
		ax_thread_search_result="/usr/lib/libc_r.so is included in LIBS."
		;;
	*bsd* )
		CXXFLAGS="-pthread $CXXFLAGS"
		ax_thread_search_result="-pthread is included in CXXFLAGS."
		;;
	*)
	esac
    AC_MSG_RESULT($ax_thread_search_result)

    AC_SUBST(CXXFLAGS)
    AC_SUBST(LIBS)

    #
    # The suffix of a shared object is examined.
    #
    AC_MSG_CHECKING(for shared library suffix)

    case "$build_os" in
    cygwin* | mingw* | pw32*)
        SHREXT=".dll" ;;
    *)
        SHREXT=".so" ;;
    esac
    AC_MSG_RESULT($SHREXT)
    AC_SUBST(SHREXT)

    AC_CHECK_LIB(dl, dlopen, [LIBS="$LIBS -ldl"])

    export CXXFLAGS

    #
    # ѥ餬 /lib /usr/lib ʳΥ饤֥ߤƤ뤫å
    # 㤨Хѥɲäǥ󥹥ȡ뤷Ϥɲ
    #
    case "$CXX" in
    gcc*|g++*)
        #
        # gcc  -v ɽ Configured with:  --libdir= 
        # libstdc++ ʤɤΥ饤ְ֥֤ȤʤäƤ
        #
        ax_stdlib_dir=`$CXX -v 2>&1 | sed -n "s,.*libdir=\([[^ ]]*\).*,\1,p"`
    esac

    if test "x"$ax_stdlib_dir != x ; then
        AC_MSG_NOTICE($ax_stdlib_dir is added to the library directory.)
        LDFLAGS="-L$ax_stdlib_dir $LDFLAGS"
        export LDFLAGS
    fi

    #
    # -Wall ץͭξɲä
    #
    AC_CACHE_CHECK([whether -Wall works], Wall_flag, [
        saved_CXXFLAGS=$CXXFLAGS
        CXXFLAGS="-Wall"
        AC_TRY_COMPILE(, , Wall_flag=yes, Wall_flag=no)
        CXXFLAGS=$saved_CXXFLAGS
        ])
    if test "x$Wall_flag" = xyes; then
        CXXFLAGS="$CXXFLAGS -Wall"
    fi
])
