/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef SERVLET_JSP_TAGEXT_TAG_SUPPORT_H
#define SERVLET_JSP_TAGEXT_TAG_SUPPORT_H

#include <map>
#include <string>
#include <vector>

#include <sl/java/lang/Object.h>
#include <servlet/jsp/JspException.h>
#include <servlet/jsp/PageContext.h>
#include <servlet/jsp/tagext/IterationTag.h>

namespace servlet {
namespace jsp {
namespace tagext {

class TagSupport : virtual public IterationTag {

    typedef std::map<std::string, sl::java::lang::Object> value_map_t;

public :

    TagSupport();

    virtual ~TagSupport();

    virtual int doAfterBody() throw(JspException);

    virtual int doStartTag() throw(JspException);

    virtual int doEndTag() throw(JspException);

    virtual void release();

    virtual void setPageContext(PageContext& context);

    std::string getId();

    void setId(const std::string& id);

    Tag& getParent();

    void setParent(Tag& tag);

    sl::java::lang::Object getValue(const std::string& k);

    std::vector<sl::java::lang::Object> getValues();

    void setValue(const std::string& k, sl::java::lang::Object o);

protected :

    PageContext* pageContext;

private :
    value_map_t _value_map;
    Tag* _parent_tag;
    std::string _id;
};

} // namespace tagext
} // namespace jsp
} // namespace servlet

#endif // _SERVLET_JSP_TAGEXT_TAG_SUPPORT_H
