/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef SERVLET_JSP_TAG_TAG_INFO_H
#define SERVLET_JSP_TAG_TAG_INFO_H

#include <string>
#include <vector>

#include <servlet/jsp/tagext/TagData.h>
#include <servlet/jsp/tagext/TagExtraInfo.h>
#include <servlet/jsp/tagext/TagLibraryInfo.h>
#include <servlet/jsp/tagext/TagAttributeInfo.h>
#include <servlet/jsp/tagext/TagVariableInfo.h>

namespace servlet {
namespace jsp {
namespace tagext {

class TagInfo {
public :
    TagInfo() { }

    TagInfo(const std::string& tag_name,
            const std::string& tag_class_name,
            const std::string& body_content,
            const std::string& info_string,
            TagLibraryInfo& taglib,
            TagExtraInfo& tagExtraInfo,
            std::vector<TagAttributeInfo> attributeInfo,
            const std::string& displayName,
            const std::string& smallIcon,
            const std::string& largeIcon,
            std::vector<TagVariableInfo> tvi);

    virtual ~TagInfo() { }

    std::vector<VariableInfo> getAttributes();

    std::string getBodyContent();

    std::string getDisplayName();

    std::string getInfoString();

    std::string getLargeIcon();

    std::string getSmallIcon();

    std::string getTagClassName();

    TagExtraInfo& getTagExtraInfo();

    TagLibraryInfo& getTagLibrary();

    std::string getTagName();

    std::vector<VariableInfo> getTabVariableInfos();

    std::vector<VariableInfo> getTabVariableInfo(TagData& data);

    bool isValid(TagData& data);

    TagInfo& getTagInfo();

    void setTagExtraInfo(TagExtraInfo& tag_info);

    void setTagLibraryInfo(TagLibraryInfo& tag_info);
};

} // namespace tagext
} // namespace jsp
} // namespace servlet

#endif // SERVLET_JSP_TAG_TAG_INFO_H
