/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef SERVLET_JSP_TAGEXT_BODY_TAG_SUPPORT_H
#define SERVLET_JSP_TAGEXT_BODY_TAG_SUPPORT_H

#include <servlet/jsp/JspWriter.h>
#include <servlet/jsp/JspException.h>
#include <servlet/jsp/tagext/TagSupport.h>
#include <servlet/jsp/tagext/BodyTag.h>

namespace servlet {
namespace jsp {
namespace tagext {

class BodyTagSupport : virtual TagSupport, virtual public BodyTag {
public :
    enum {
        EVAL_BODY_BUFFERED = 0x31,
        EVAL_BODY_TAG_SUPPORT = 0x32
    };

    BodyTagSupport() { }

    virtual ~BodyTagSupport() throw() { }

    virtual void doInitBody() throw(JspException);

    virtual void setBodyContent();

    virtual int doAfterBody() throw(JspException);

    virtual int doStartBody() throw(JspException);

    virtual int doEndBody() throw(JspException);

    virtual void release();

    virtual BodyContent &getBodyContent();

    virtual JspWriter &getPreviousOut();
};

} // namespace tagext
} // namespace jsp
} // namespace servlet

#endif // SERVLET_JSP_TAGEXT_BODY_TAG_SUPPORT_H
