/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef SERVLET_JSP_TAGEXT_BODY_CONTENT_H
#define SERVLET_JSP_TAGEXT_BODY_CONTENT_H

#include <iostream>

#include <servlet/jsp/JspWriter.h>

namespace servlet {
namespace jsp {
namespace tagext {

class BodyContent : public JspWriter {
protected :
    BodyContent(JspWriter& writer)
      : JspWriter(writer)
    { }

public :

    virtual ~BodyContent() { }

    virtual void clearBody()=0; 
    virtual void flush()=0; // throw (IOException)

    virtual JspWriter &getEnclosingWriter()=0;

    virtual sl::java::io::Reader& getReader()=0;

    virtual std::string getString()=0;

    virtual void writeOut(std::ostream &out)=0; // throw (IOException)
};

} // namespace tagext
} // namespace jsp
} // namespace servlet

#endif // SERVLET_JSP_TAGEXT_BODY_CONTENT_H
