/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef SERVLET_JSP_EL_FUNCTION_MAPPER_H
#define SERVLET_JSP_EL_FUNCTION_MAPPER_H

#include <string>
#include <vector>
#include <sl/java/lang/Object.h>

namespace servlet {
namespace jsp {
namespace el {

/**
 * @interface FunctionMapper.
 *
 * ELѤδؿ̾ޥåԥ󥰤륯饹.
 * Υ饹ϻͤɤ˻ѤƤޤ.
 * ʤ java.reflect. Method Ѥ
 * ̾ºݤΥ饹᥽åɤФƼ¹ԤƤޤ
 * C++ ˤ java.reflect Τ褦ʼ¹Ի̾дؿ
 * Ф褦ʵǽϤʤΤǡºݤˤ JSP ե뤫
 * Servlet Υ˴ؿƽФΥåޤƤޤ.
 * ΤᡢΥ饹 `ؿμ' ǤϤʤ `ؿμ¹' Ԥʤޤ.
 */
class FunctionMapper {
public :
    virtual ~FunctionMapper() { }

    // javalang.reflect.Method
    // resolveFunction(java.lang.String prefix,java.lang.String localName);

    virtual
    std::string resolveFunction(const std::string& prefix,
                                const std::string& name) const=0;

    /**
     * prefixnameоݤȤʤؿ򸡺
     * objs ȤƼ¹Ԥޤ.
     *
     * @param    prefix    JSP ե taglib ǥ쥯ƥ֤
     *                    Ƥץեå.
     * @param    name    TLD եƤؿ̾.
     * @param    objs    Υꥹ.
     * @return    ؿμ¹Է̤ݻ륪֥.
     */
    virtual
    sl::java::lang::Object resolveFunction(const std::string& prefix,
                            const std::string& name,
                            std::vector<sl::java::lang::Object>& objs) const=0;
};

} // namespace el
} // namespace jsp
} // namespace servlet

#endif // SERVLET_JSP_EL_FUNCTION_MAPPER_H
