/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef SERVLET_JSP_EL_EXPRESSION_EVALUATOR_H
#define SERVLET_JSP_EL_EXPRESSION_EVALUATOR_H

#include <string>
#include <memory>

#include <sl/java/lang/Class.h>
#include <sl/java/lang/Object.h>
#include <servlet/jsp/el/ELException.h>
#include <servlet/jsp/el/ELParseException.h>
#include <servlet/jsp/el/Expression.h>
#include <servlet/jsp/el/FunctionMapper.h>
#include <servlet/jsp/el/VariableResolver.h>

namespace servlet {
namespace jsp {
namespace el {

/**
 * @class ExpressionEvaluator
 *
 * EL βϡ¹ԤԤʤ饹.
 * parseExpression ʤƤдؿ⤢Τǡ
 *  Expression 饹˲Ϸ̤ȤϤ뼰ξ
 * ֤ꤹ뤿Υ饹Τ褦Ǥ.
 */
class ExpressionEvaluator {
public :
    virtual ~ExpressionEvaluator() { }

    /**
     * EL μ¹.
     * ʤ˼¹ԤдؿΤ parseExpression ؿ
     * ¸ߤƤΤ...
     * Ѹɤʤʹ֤ˤ˶줷Ǥ.
     * 
     * @param    expression    EL. 
     * @param    type        饹`'.
     * @param    resolver    ֥ȤؤΥѤ
     * @param    mapper        EL Function ؤΥѤ
     * 
     * @return    ELɾ̤ݻ ֤.
     */
    virtual sl::java::lang::Object evaluate(const std::string& expression,
                                            const sl::java::lang::Class& type,
                                            const VariableResolver& resolver,
                                            const FunctionMapper& mapper)
        throw (ELException)=0;

    /**
     * ELɾ.
     *
     * @param    expression    EL . 
     * @return    std::auto_ptr ˻ Expression 󥹥.
     */
    virtual
    std::auto_ptr<Expression> parseExpression(const std::string& expression,
                                              const sl::java::lang::Class& type,
                                              const FunctionMapper& fMapper)
        throw (ELParseException)=0;
};

} // namespace el
} // namespace jsp
} // namespace servlet

#endif // SERVLET_JSP_EL_EXPRESSION_EVALUATOR_H
