/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef SERVLET_JSP_PAGE_CONTEXT_H
#define SERVLET_JSP_PAGE_CONTEXT_H

#include <set>
#include <string>

#include <sl/java/lang/Object.h>
#include <servlet/Servlet.h>
#include <servlet/ServletRequest.h>
#include <servlet/ServletResponse.h>
#include <servlet/ServletConfig.h>
#include <servlet/ServletContext.h>
#include <servlet/http/HttpSession.h>
#include <servlet/jsp/JspContext.h>

namespace servlet {
namespace jsp {

namespace tagext {
    class BodyContent;
}

/**
 * @class PageContext.
 * 
 * JSP 濴Ū¸ߤʥ饹.
 * 饹ȥ᥽åɤǥץ벽ȤȤäƤ뤬
 * ɤĤϤʤǤ㤦.
 */
class PageContext : public JspContext {
public :

    /** application Υ׻Ѥ.  */
    static const int    APPLICATION_SCOPE    = 0;

    /** page Υ׻Ѥ.  */
    static const int    PAGE_SCOPE           = 1;

    /** session Υ׻Ѥ.  */
    static const int    SESSION_SCOPE        = 2;

    /** request Υ׻Ѥ.  */
    static const int    REQUEST_SCOPE        = 3;

    static const std::string APPLICATION;
    static const std::string PAGECONTEXT;
    static const std::string CONFIG;
    static const std::string EXCEPTION;
    static const std::string OUT;
    static const std::string PAGE;
    static const std::string REQUEST;
    static const std::string RESPONSE;
    static const std::string SESSION;

    /** Destructor. */
    virtual ~PageContext() { }

    /**
     * RequestDispatcher.forward() ưԤʤޤ.
     */
    virtual void forward(const std::string &url_path)=0;

    /**
     * 㳰֥Ȥθߤ֤ͤޤ.
     */
    virtual std::exception& getException()=0;

        /**
     * ڡ֥(Servlet)θߤ֤ͤޤ.
     */
    virtual sl::java::lang::Object getPage()=0;

        /**
     * ꥯȥ֥(ServletRequest)θߤ֤ͤޤ.
     */
    virtual ServletRequest& getRequest()=0;

        /**
     * 쥹ݥ󥹥֥(ServletResponse)θߤ֤ͤޤ.
     */
    virtual ServletResponse& getResponse()=0;

    /**
         * ServletConfigΥ󥹥󥹤֤ޤ
     */
    virtual ServletConfig& getServletConfig()=0;

    /**
         * ServletContextΥ󥹥󥹤֤ޤ
     */
    virtual ServletContext& getServletContext()=0;

    /**
         * å󥪥֥ȡHttpSessionˤθߤ֤ͤޤ
     */
    virtual http::HttpSession &getSession()=0;

    /**
         * Υ᥽åɤϽǤʤ"ڡ"٥㳰
     * JSPѰդƤꤷ顼ڡ
     * 쥯Ȥ뤳ȤˤäƽŪȤƤޤ.
     */
    virtual void handlePageException(std::exception& e)=0;

    /**
         * ꤷ꥽򡢸ƤӽФåɤˤäƽƤ
     * ߤ ServletRequestServletResponseΰȤƽޤ
     */
    virtual void include(const std::string& url_path)=0;

    /**
         * initialize᥽åɤϡƤʤPageContext
     * 뤿˸ƤӽФޤ
     */
    virtual void initialize(Servlet& s,
                            ServletRequest& req,
                            ServletResponse& res,
                            const std::string& error_page_url,
                            bool needs_session,
                            int buffer_size,
                            bool auto_flush)=0;

    /**
         * BodyContent֥Ȥ֤Ƹߤ "out" JspWriter
     * ¸ PageContextΥڡ°֤̾ˤ
     * "out"°ͤ򥢥åץǡȤޤ
     */
    virtual tagext::BodyContent& pushBody()=0;

    /**
         * Υ᥽åɤΤ٤ƤλȤinitialize()
     * ƤӽФݤ˺Ѳǽˤ뤿PageContextǡ
     * PageContextξ֤֥ꥻåȡפޤ.
     */
    virtual void release()=0;

};

} // namespace jsp
} // namespace servlet

#endif // SERVLET_JSP_PAGE_CONTEXT_H
