/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef SERVLET_JSP_JSP_WRITER_H
#define SERVLET_JSP_JSP_WRITER_H

#include <sstream>

#include <sl/java/io/Writer.h>

namespace servlet {
namespace jsp {

/**
 * @class JspWriter.
 *
 * JSP  Ͻ򤹤Τ˻Ȥ饹.
 *
 * ñ ServletResponse::getWriter ǤϽʤϤΥХåե󥰴ط
     *  JSP μºݤνϤ桩뤿Υ饹餷Ǥ.
 */
class JspWriter : public sl::java::io::Writer {
protected :
    JspWriter(int bufferSize, bool autoFlush)
    { }

public :
    /**
     * ХåեǤޤȤƤʤХȿ֤ޤ 
     */
    virtual int getRemaining()
    {
        return 0;
    }

    /**
     * JspWriter autoFlushѤƤ뤫ɤ֤ޤ 
     */
    bool isAutoFlush()
    {
        return true;
    }

    /**
     * ԤϤޤ.
     */
    virtual void newLine() throw(std::exception)
    {
        println();
    }

    template <typename ValueType>
    void print(ValueType x)
    {
        std::stringstream s;
        s << x;
        this->write(s.str());
    }

    void print(const char* s)
    {
        this->write(s);
    }

    void print(const std::string& s)
    {
        this->write(s);
    }

    void print(bool x)
    {
        std::string s = x ? "true" : "false";
        this->write(s);
    }

    template <typename ValueType>
    void println(ValueType x)
    {
        this->print(x);
        this->print("\r\n");
    }

    void println()
    {
        this->print("\r\n");
    }
};

} // namespace jsp
} // namespace servlet

#endif // SERVLET_JSP_JSP_WRITER_H
