/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef SERVLET_JSP_JSP_FACTORY_H
#define SERVLET_JSP_JSP_FACTORY_H

#include <string>

#include <servlet/Servlet.h>
#include <servlet/ServletRequest.h>
#include <servlet/ServletResponse.h>

namespace servlet {
namespace jsp {

class PageContext;
class JspEngineInfo;

/**
 * @class JspFactory.
 *
 * PageContext Υ󥹥󥹤Ȫ.
 */
class JspFactory {
public :
    /** Destructor. */
    virtual ~JspFactory() { }

    /**
     * default Ȫ֤Ǥ.
     *
     * @return JspFactory Υ󥹥.
     */
    static JspFactory& getDefaultFactory();

    /**
     * default Ȫꤷޤ.
     *
     * @param    def        Ȫ.
     */
    static void setDefaultFactory(JspFactory& def);

        /**
     * ߼ƤJSP󥸥ͭξ뤿˸ƤӽФޤ.
     */
    virtual JspEngineInfo& getEngineInfo()=0;

    /**
     * PageContext Υ󥹥󥹤֤ޤ.
     * 
     * @param    s       Servlet 󥹥.
     * @param    req        ServletRequest.
     * @param    res        ServletResponse.
     * @param    error_page_url     顼ڡURL.
     * @param    needs_session    åλ̵ͭ.
     * @param    buffer    
     * @param    autoflush
     * @return   PageContext 󥹥󥹤ؤλ.
     */
    virtual PageContext& getPageContext(servlet::Servlet& s,
                                        servlet::ServletRequest& req,
                                        servlet::ServletResponse& res,
                                        std::string error_page_url,
                                        bool needs_session,
                                        int buffer,
                                        bool auto_flush)=0;

    /**
     * פˤʤä PageContext 󥹥󥹤ޤ.
     *
     * @param    context        ƥ.
     */
    virtual void releasePageContext(PageContext& context)=0;

private :
    static JspFactory* _jsp_factory;
};

} // namespace jsp
} // namespace servlet

#endif // SERVLET_JSP_JSP_FACTORY_H
