/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef SERVLET_JSP_JSP_CONTEXT_H
#define SERVLET_JSP_JSP_CONTEXT_H

#include <string>

#include <sl/java/lang/Object.h>
#include <sl/java/io/Writer.h>
#include <sl/java/util/Enumeration.h>
#include <servlet/jsp/JspWriter.h>

namespace servlet {
namespace jsp {

namespace el {
    class ExpressionEvaluator;
    class VariableResolver;
}

/**
 * @class JspContext.
 *
 *
 */
class JspContext {
public :

    JspContext();
 
    virtual ~JspContext();

        /**
     * pageContextrequestsession(if needs_session is true)
     * application 4ĤΥפϿƤ°򸡺ޤ.
     *
     * @param    name    °̾.
     * @return    줿֥.
     */
    virtual sl::java::lang::Object findAttribute(const std::string& name)=0;

        /**
     * Ϳ̾б֥Ȥ֤ޤ.
     *
     * @param    name    оݤ°Ф̾.
     * @return     name Ф°֥.
     */
    virtual sl::java::lang::Object getAttribute(const std::string& name)=0;

        /**
     * ΥǰͿ̾б֥Ȥ֤ޤ.
     *
     * @param    name    оݤ°Ф̾.
     * @param    scope    оݤΥ.
     * @return     name Ф°֥.
     */
    virtual sl::java::lang::Object
    getAttribute(const std::string& name, int scope)=0;

        /**
     * ꤷƤ°̾ޤ.
     *
     * @param    scope    оݤΥ.
     * @return     name Ф°֥.
     */
    virtual
    sl::java::util::Enumeration getAttributeNamesInScope(int scope)=0;

        /**
     * ̾°Ƥ륹פޤ.
     */
    virtual int getAttributesScope(const std::string& name)=0;

    /**
     * el::ExpressionEvaluator Υ󥹥󥹤ؤλȤ֤ޤ.
     * 
     * @return el::ExpressionEvaluator &.
     */
    virtual el::ExpressionEvaluator& getExpressionEvaluator()=0;

        /**
     * out֥JspWriterθߤ֤ͤޤ.
     */
    virtual JspWriter& getOut()=0;

    /**
     * ۤΥ֥Ȥ˥뤿ɬפ 
     * el::VariableResolve Υ󥹥()֤ޤ. 
     * 
     * @return el::VariableResolver& . 
     */
    virtual el::VariableResolver& getVariableResolver()=0;

    /**
         *Υ᥽åɤб᥽åɡpushBody()ˤ¸줿
     *  JspWriter "out"֤JspContextΥڡ°
     * ֤̾ˤ"out"°ͤ򥢥åץǡȤޤ
     */
    virtual JspWriter& popBody();

    /**
         * BodyContent֥Ȥ֤Ƹߤ "out" JspWriter
     * ¸ JspContextΥڡ°֤̾ˤ
     * "out"°ͤ򥢥åץǡȤޤ
     */
    virtual JspWriter& pushBody(const sl::java::io::Writer& writer);

    /**
         * ƤΥפǡ̾˴Ϣդ줿֥Ȥؤ
     * Ȥޤ.
     */
    virtual void removeAttribute(const std::string& name)=0;

    /**
         * Υפǡ̾˴Ϣդ줿֥Ȥؤ
     * Ȥޤ
     */
    virtual void removeAttribute(const std::string& name, int scope)=0;

    /**
         * ڡפ줿̾ȥ֥ȤϿޤ
     */
    virtual void setAttribute(const std::string& name,
                              sl::java::lang::Object attribute)=0;

    /**
         * 򤷤פ줿̾ȥ֥ȤϿޤ
     */
    virtual void setAttribute(const std::string& name,
                              sl::java::lang::Object o, int scope)=0;

private :
    JspWriter* _dummy_writer;
};

} // namespace jsp
} // namespace servlet

#endif // SERVLET_JSP_JSP_CONTEXT_H
