/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef SERVLET_HTTP_HTTP_SESSION_H
#define SERVLET_HTTP_HTTP_SESSION_H

#include <set>
#include <stdexcept>

#include <sl/java/lang/Object.h>
#include <sl/java/lang/IllegalStateException.h>
#include <sl/java/util/Enumeration.h>
#include <servlet/ServletContext.h>

namespace servlet {
namespace http {

class HttpSession {
public :
    /** Destructor. */
    virtual ~HttpSession();

    virtual bool operator!() const=0;

    virtual operator const void* () const { return operator!() ? 0 : this; }

    virtual sl::java::lang::Object getAttribute(const std::string& s)
        throw(sl::java::lang::IllegalStateException)=0;

    virtual
    void setAttribute(const std::string& s, sl::java::lang::Object o)
        throw(sl::java::lang::IllegalStateException)=0;

    virtual void removeAttribute(const std::string& s)
        throw(sl::java::lang::IllegalStateException)=0;

    virtual sl::java::util::Enumeration getAttributeNames()
        throw(sl::java::lang::IllegalStateException)=0;

    virtual long getCreationTime()
        throw(sl::java::lang::IllegalStateException)=0;

    virtual std::string getId()
        throw(sl::java::lang::IllegalStateException)=0;

    virtual long getLastAccessedTime()
        throw(sl::java::lang::IllegalStateException)=0;

    virtual ServletContext& getServletContext()=0;

    virtual void setMaxInactiveInterval(int i)=0;

    virtual int getMaxInactiveInterval()=0;
};

} // namespace http
} // namespace servlet

#endif // SERVLET_HTTP_HTTP_SESSION_H
